/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.translate.model.TranslatedDocument;
import java.nio.ByteBuffer;

@SdkInternalApi
public class TranslatedDocumentMarshaller {
    private static final MarshallingInfo<ByteBuffer> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Content").build();
    private static final TranslatedDocumentMarshaller instance = new TranslatedDocumentMarshaller();

    public static TranslatedDocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(TranslatedDocument translatedDocument, ProtocolMarshaller protocolMarshaller) {
        if (translatedDocument == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)translatedDocument.getContent(), CONTENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

