/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.translate;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.translate.AmazonTranslate;
import com.amazonaws.services.translate.AmazonTranslateClientBuilder;
import com.amazonaws.services.translate.model.AmazonTranslateException;
import com.amazonaws.services.translate.model.CreateParallelDataRequest;
import com.amazonaws.services.translate.model.CreateParallelDataResult;
import com.amazonaws.services.translate.model.DeleteParallelDataRequest;
import com.amazonaws.services.translate.model.DeleteParallelDataResult;
import com.amazonaws.services.translate.model.DeleteTerminologyRequest;
import com.amazonaws.services.translate.model.DeleteTerminologyResult;
import com.amazonaws.services.translate.model.DescribeTextTranslationJobRequest;
import com.amazonaws.services.translate.model.DescribeTextTranslationJobResult;
import com.amazonaws.services.translate.model.GetParallelDataRequest;
import com.amazonaws.services.translate.model.GetParallelDataResult;
import com.amazonaws.services.translate.model.GetTerminologyRequest;
import com.amazonaws.services.translate.model.GetTerminologyResult;
import com.amazonaws.services.translate.model.ImportTerminologyRequest;
import com.amazonaws.services.translate.model.ImportTerminologyResult;
import com.amazonaws.services.translate.model.ListLanguagesRequest;
import com.amazonaws.services.translate.model.ListLanguagesResult;
import com.amazonaws.services.translate.model.ListParallelDataRequest;
import com.amazonaws.services.translate.model.ListParallelDataResult;
import com.amazonaws.services.translate.model.ListTagsForResourceRequest;
import com.amazonaws.services.translate.model.ListTagsForResourceResult;
import com.amazonaws.services.translate.model.ListTerminologiesRequest;
import com.amazonaws.services.translate.model.ListTerminologiesResult;
import com.amazonaws.services.translate.model.ListTextTranslationJobsRequest;
import com.amazonaws.services.translate.model.ListTextTranslationJobsResult;
import com.amazonaws.services.translate.model.StartTextTranslationJobRequest;
import com.amazonaws.services.translate.model.StartTextTranslationJobResult;
import com.amazonaws.services.translate.model.StopTextTranslationJobRequest;
import com.amazonaws.services.translate.model.StopTextTranslationJobResult;
import com.amazonaws.services.translate.model.TagResourceRequest;
import com.amazonaws.services.translate.model.TagResourceResult;
import com.amazonaws.services.translate.model.TranslateTextRequest;
import com.amazonaws.services.translate.model.TranslateTextResult;
import com.amazonaws.services.translate.model.UntagResourceRequest;
import com.amazonaws.services.translate.model.UntagResourceResult;
import com.amazonaws.services.translate.model.UpdateParallelDataRequest;
import com.amazonaws.services.translate.model.UpdateParallelDataResult;
import com.amazonaws.services.translate.model.transform.ConcurrentModificationExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.CreateParallelDataRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.CreateParallelDataResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.DeleteParallelDataRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.DeleteParallelDataResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.DeleteTerminologyRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.DeleteTerminologyResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.DescribeTextTranslationJobRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.DescribeTextTranslationJobResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.DetectedLanguageLowConfidenceExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.GetParallelDataRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.GetParallelDataResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.GetTerminologyRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.GetTerminologyResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.ImportTerminologyRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.ImportTerminologyResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.InvalidFilterExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.ListLanguagesRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.ListLanguagesResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.ListParallelDataRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.ListParallelDataResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.ListTerminologiesRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.ListTerminologiesResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.ListTextTranslationJobsRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.ListTextTranslationJobsResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.StartTextTranslationJobRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.StartTextTranslationJobResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.StopTextTranslationJobRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.StopTextTranslationJobResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.TextSizeLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.TooManyTagsExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.TranslateTextRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.TranslateTextResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.UnsupportedDisplayLanguageCodeExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.UnsupportedLanguagePairExceptionUnmarshaller;
import com.amazonaws.services.translate.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.translate.model.transform.UpdateParallelDataRequestProtocolMarshaller;
import com.amazonaws.services.translate.model.transform.UpdateParallelDataResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonTranslateClient
extends AmazonWebServiceClient
implements AmazonTranslate {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonTranslate.class);
    private static final String DEFAULT_SIGNING_NAME = "translate";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConcurrentModificationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyTagsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DetectedLanguageLowConfidenceException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DetectedLanguageLowConfidenceExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterValueException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidParameterValueExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedLanguagePairException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedLanguagePairExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidFilterException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidFilterExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TextSizeLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TextSizeLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedDisplayLanguageCodeException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnsupportedDisplayLanguageCodeExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyRequestsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonTranslateException.class));

    public static AmazonTranslateClientBuilder builder() {
        return AmazonTranslateClientBuilder.standard();
    }

    AmazonTranslateClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonTranslateClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("translate.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/translate/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/translate/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateParallelDataResult createParallelData(CreateParallelDataRequest request) {
        request = (CreateParallelDataRequest)this.beforeClientExecution(request);
        return this.executeCreateParallelData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateParallelDataResult executeCreateParallelData(CreateParallelDataRequest createParallelDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createParallelDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateParallelDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateParallelDataRequestProtocolMarshaller(protocolFactory).marshall((CreateParallelDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)createParallelDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateParallelData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateParallelDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateParallelDataResult createParallelDataResult = (CreateParallelDataResult)response.getAwsResponse();
            return createParallelDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteParallelDataResult deleteParallelData(DeleteParallelDataRequest request) {
        request = (DeleteParallelDataRequest)this.beforeClientExecution(request);
        return this.executeDeleteParallelData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteParallelDataResult executeDeleteParallelData(DeleteParallelDataRequest deleteParallelDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteParallelDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteParallelDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteParallelDataRequestProtocolMarshaller(protocolFactory).marshall((DeleteParallelDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteParallelDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteParallelData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteParallelDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteParallelDataResult deleteParallelDataResult = (DeleteParallelDataResult)response.getAwsResponse();
            return deleteParallelDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTerminologyResult deleteTerminology(DeleteTerminologyRequest request) {
        request = (DeleteTerminologyRequest)this.beforeClientExecution(request);
        return this.executeDeleteTerminology(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTerminologyResult executeDeleteTerminology(DeleteTerminologyRequest deleteTerminologyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTerminologyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTerminologyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTerminologyRequestProtocolMarshaller(protocolFactory).marshall((DeleteTerminologyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTerminologyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTerminology");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTerminologyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTerminologyResult deleteTerminologyResult = (DeleteTerminologyResult)response.getAwsResponse();
            return deleteTerminologyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTextTranslationJobResult describeTextTranslationJob(DescribeTextTranslationJobRequest request) {
        request = (DescribeTextTranslationJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeTextTranslationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeTextTranslationJobResult executeDescribeTextTranslationJob(DescribeTextTranslationJobRequest describeTextTranslationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTextTranslationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTextTranslationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTextTranslationJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeTextTranslationJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTextTranslationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeTextTranslationJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeTextTranslationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTextTranslationJobResult describeTextTranslationJobResult = (DescribeTextTranslationJobResult)response.getAwsResponse();
            return describeTextTranslationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetParallelDataResult getParallelData(GetParallelDataRequest request) {
        request = (GetParallelDataRequest)this.beforeClientExecution(request);
        return this.executeGetParallelData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetParallelDataResult executeGetParallelData(GetParallelDataRequest getParallelDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getParallelDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetParallelDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetParallelDataRequestProtocolMarshaller(protocolFactory).marshall((GetParallelDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getParallelDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetParallelData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetParallelDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetParallelDataResult getParallelDataResult = (GetParallelDataResult)response.getAwsResponse();
            return getParallelDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTerminologyResult getTerminology(GetTerminologyRequest request) {
        request = (GetTerminologyRequest)this.beforeClientExecution(request);
        return this.executeGetTerminology(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTerminologyResult executeGetTerminology(GetTerminologyRequest getTerminologyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTerminologyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTerminologyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTerminologyRequestProtocolMarshaller(protocolFactory).marshall((GetTerminologyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTerminologyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTerminology");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTerminologyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTerminologyResult getTerminologyResult = (GetTerminologyResult)response.getAwsResponse();
            return getTerminologyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ImportTerminologyResult importTerminology(ImportTerminologyRequest request) {
        request = (ImportTerminologyRequest)this.beforeClientExecution(request);
        return this.executeImportTerminology(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ImportTerminologyResult executeImportTerminology(ImportTerminologyRequest importTerminologyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(importTerminologyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ImportTerminologyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ImportTerminologyRequestProtocolMarshaller(protocolFactory).marshall((ImportTerminologyRequest)super.beforeMarshalling((AmazonWebServiceRequest)importTerminologyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ImportTerminology");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ImportTerminologyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ImportTerminologyResult importTerminologyResult = (ImportTerminologyResult)response.getAwsResponse();
            return importTerminologyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLanguagesResult listLanguages(ListLanguagesRequest request) {
        request = (ListLanguagesRequest)this.beforeClientExecution(request);
        return this.executeListLanguages(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListLanguagesResult executeListLanguages(ListLanguagesRequest listLanguagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLanguagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLanguagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLanguagesRequestProtocolMarshaller(protocolFactory).marshall((ListLanguagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLanguagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListLanguages");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListLanguagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListLanguagesResult listLanguagesResult = (ListLanguagesResult)response.getAwsResponse();
            return listLanguagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListParallelDataResult listParallelData(ListParallelDataRequest request) {
        request = (ListParallelDataRequest)this.beforeClientExecution(request);
        return this.executeListParallelData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListParallelDataResult executeListParallelData(ListParallelDataRequest listParallelDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listParallelDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListParallelDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListParallelDataRequestProtocolMarshaller(protocolFactory).marshall((ListParallelDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)listParallelDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListParallelData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListParallelDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListParallelDataResult listParallelDataResult = (ListParallelDataResult)response.getAwsResponse();
            return listParallelDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTerminologiesResult listTerminologies(ListTerminologiesRequest request) {
        request = (ListTerminologiesRequest)this.beforeClientExecution(request);
        return this.executeListTerminologies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTerminologiesResult executeListTerminologies(ListTerminologiesRequest listTerminologiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTerminologiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTerminologiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTerminologiesRequestProtocolMarshaller(protocolFactory).marshall((ListTerminologiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTerminologiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTerminologies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTerminologiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTerminologiesResult listTerminologiesResult = (ListTerminologiesResult)response.getAwsResponse();
            return listTerminologiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTextTranslationJobsResult listTextTranslationJobs(ListTextTranslationJobsRequest request) {
        request = (ListTextTranslationJobsRequest)this.beforeClientExecution(request);
        return this.executeListTextTranslationJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTextTranslationJobsResult executeListTextTranslationJobs(ListTextTranslationJobsRequest listTextTranslationJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTextTranslationJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTextTranslationJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTextTranslationJobsRequestProtocolMarshaller(protocolFactory).marshall((ListTextTranslationJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTextTranslationJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTextTranslationJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTextTranslationJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTextTranslationJobsResult listTextTranslationJobsResult = (ListTextTranslationJobsResult)response.getAwsResponse();
            return listTextTranslationJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartTextTranslationJobResult startTextTranslationJob(StartTextTranslationJobRequest request) {
        request = (StartTextTranslationJobRequest)this.beforeClientExecution(request);
        return this.executeStartTextTranslationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartTextTranslationJobResult executeStartTextTranslationJob(StartTextTranslationJobRequest startTextTranslationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startTextTranslationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartTextTranslationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartTextTranslationJobRequestProtocolMarshaller(protocolFactory).marshall((StartTextTranslationJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startTextTranslationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartTextTranslationJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartTextTranslationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartTextTranslationJobResult startTextTranslationJobResult = (StartTextTranslationJobResult)response.getAwsResponse();
            return startTextTranslationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopTextTranslationJobResult stopTextTranslationJob(StopTextTranslationJobRequest request) {
        request = (StopTextTranslationJobRequest)this.beforeClientExecution(request);
        return this.executeStopTextTranslationJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopTextTranslationJobResult executeStopTextTranslationJob(StopTextTranslationJobRequest stopTextTranslationJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopTextTranslationJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopTextTranslationJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopTextTranslationJobRequestProtocolMarshaller(protocolFactory).marshall((StopTextTranslationJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopTextTranslationJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopTextTranslationJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopTextTranslationJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopTextTranslationJobResult stopTextTranslationJobResult = (StopTextTranslationJobResult)response.getAwsResponse();
            return stopTextTranslationJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TranslateTextResult translateText(TranslateTextRequest request) {
        request = (TranslateTextRequest)this.beforeClientExecution(request);
        return this.executeTranslateText(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TranslateTextResult executeTranslateText(TranslateTextRequest translateTextRequest) {
        ExecutionContext executionContext = this.createExecutionContext(translateTextRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TranslateTextRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TranslateTextRequestProtocolMarshaller(protocolFactory).marshall((TranslateTextRequest)super.beforeMarshalling((AmazonWebServiceRequest)translateTextRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TranslateText");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TranslateTextResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TranslateTextResult translateTextResult = (TranslateTextResult)response.getAwsResponse();
            return translateTextResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateParallelDataResult updateParallelData(UpdateParallelDataRequest request) {
        request = (UpdateParallelDataRequest)this.beforeClientExecution(request);
        return this.executeUpdateParallelData(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateParallelDataResult executeUpdateParallelData(UpdateParallelDataRequest updateParallelDataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateParallelDataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateParallelDataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateParallelDataRequestProtocolMarshaller(protocolFactory).marshall((UpdateParallelDataRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateParallelDataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Translate");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateParallelData");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateParallelDataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateParallelDataResult updateParallelDataResult = (UpdateParallelDataResult)response.getAwsResponse();
            return updateParallelDataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

