/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.transfer.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/ListAccesses" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListAccessesRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Specifies the maximum number of access SIDs to return.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter
     * is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to
     * continue listing additional accesses.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * A system-assigned unique identifier for a server that has users assigned to it.
     * </p>
     */
    private String serverId;

    /**
     * <p>
     * Specifies the maximum number of access SIDs to return.
     * </p>
     * 
     * @param maxResults
     *        Specifies the maximum number of access SIDs to return.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * Specifies the maximum number of access SIDs to return.
     * </p>
     * 
     * @return Specifies the maximum number of access SIDs to return.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * Specifies the maximum number of access SIDs to return.
     * </p>
     * 
     * @param maxResults
     *        Specifies the maximum number of access SIDs to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAccessesRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter
     * is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to
     * continue listing additional accesses.
     * </p>
     * 
     * @param nextToken
     *        When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code>
     *        parameter is returned in the output. You can then pass in a subsequent command to the
     *        <code>NextToken</code> parameter to continue listing additional accesses.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter
     * is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to
     * continue listing additional accesses.
     * </p>
     * 
     * @return When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code>
     *         parameter is returned in the output. You can then pass in a subsequent command to the
     *         <code>NextToken</code> parameter to continue listing additional accesses.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code> parameter
     * is returned in the output. You can then pass in a subsequent command to the <code>NextToken</code> parameter to
     * continue listing additional accesses.
     * </p>
     * 
     * @param nextToken
     *        When you can get additional results from the <code>ListAccesses</code> call, a <code>NextToken</code>
     *        parameter is returned in the output. You can then pass in a subsequent command to the
     *        <code>NextToken</code> parameter to continue listing additional accesses.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAccessesRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * A system-assigned unique identifier for a server that has users assigned to it.
     * </p>
     * 
     * @param serverId
     *        A system-assigned unique identifier for a server that has users assigned to it.
     */

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    /**
     * <p>
     * A system-assigned unique identifier for a server that has users assigned to it.
     * </p>
     * 
     * @return A system-assigned unique identifier for a server that has users assigned to it.
     */

    public String getServerId() {
        return this.serverId;
    }

    /**
     * <p>
     * A system-assigned unique identifier for a server that has users assigned to it.
     * </p>
     * 
     * @param serverId
     *        A system-assigned unique identifier for a server that has users assigned to it.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListAccessesRequest withServerId(String serverId) {
        setServerId(serverId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getServerId() != null)
            sb.append("ServerId: ").append(getServerId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListAccessesRequest == false)
            return false;
        ListAccessesRequest other = (ListAccessesRequest) obj;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getServerId() == null ^ this.getServerId() == null)
            return false;
        if (other.getServerId() != null && other.getServerId().equals(this.getServerId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getServerId() == null) ? 0 : getServerId().hashCode());
        return hashCode;
    }

    @Override
    public ListAccessesRequest clone() {
        return (ListAccessesRequest) super.clone();
    }

}
