/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transfer.model.ProfileType;
import com.amazonaws.services.transfer.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateProfileRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String as2Id;
    private String profileType;
    private List<String> certificateIds;
    private List<Tag> tags;

    public void setAs2Id(String as2Id) {
        this.as2Id = as2Id;
    }

    public String getAs2Id() {
        return this.as2Id;
    }

    public CreateProfileRequest withAs2Id(String as2Id) {
        this.setAs2Id(as2Id);
        return this;
    }

    public void setProfileType(String profileType) {
        this.profileType = profileType;
    }

    public String getProfileType() {
        return this.profileType;
    }

    public CreateProfileRequest withProfileType(String profileType) {
        this.setProfileType(profileType);
        return this;
    }

    public CreateProfileRequest withProfileType(ProfileType profileType) {
        this.profileType = profileType.toString();
        return this;
    }

    public List<String> getCertificateIds() {
        return this.certificateIds;
    }

    public void setCertificateIds(Collection<String> certificateIds) {
        if (certificateIds == null) {
            this.certificateIds = null;
            return;
        }
        this.certificateIds = new ArrayList<String>(certificateIds);
    }

    public CreateProfileRequest withCertificateIds(String ... certificateIds) {
        if (this.certificateIds == null) {
            this.setCertificateIds(new ArrayList<String>(certificateIds.length));
        }
        for (String ele : certificateIds) {
            this.certificateIds.add(ele);
        }
        return this;
    }

    public CreateProfileRequest withCertificateIds(Collection<String> certificateIds) {
        this.setCertificateIds(certificateIds);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateProfileRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateProfileRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAs2Id() != null) {
            sb.append("As2Id: ").append(this.getAs2Id()).append(",");
        }
        if (this.getProfileType() != null) {
            sb.append("ProfileType: ").append(this.getProfileType()).append(",");
        }
        if (this.getCertificateIds() != null) {
            sb.append("CertificateIds: ").append(this.getCertificateIds()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileRequest)) {
            return false;
        }
        CreateProfileRequest other = (CreateProfileRequest)obj;
        if (other.getAs2Id() == null ^ this.getAs2Id() == null) {
            return false;
        }
        if (other.getAs2Id() != null && !other.getAs2Id().equals(this.getAs2Id())) {
            return false;
        }
        if (other.getProfileType() == null ^ this.getProfileType() == null) {
            return false;
        }
        if (other.getProfileType() != null && !other.getProfileType().equals(this.getProfileType())) {
            return false;
        }
        if (other.getCertificateIds() == null ^ this.getCertificateIds() == null) {
            return false;
        }
        if (other.getCertificateIds() != null && !other.getCertificateIds().equals(this.getCertificateIds())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAs2Id() == null ? 0 : this.getAs2Id().hashCode());
        hashCode = 31 * hashCode + (this.getProfileType() == null ? 0 : this.getProfileType().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateIds() == null ? 0 : this.getCertificateIds().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateProfileRequest clone() {
        return (CreateProfileRequest)super.clone();
    }
}

