/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.transfer.model.ListedWorkflow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListWorkflowsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ListedWorkflow> workflows;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListWorkflowsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ListedWorkflow> getWorkflows() {
        return this.workflows;
    }

    public void setWorkflows(Collection<ListedWorkflow> workflows) {
        if (workflows == null) {
            this.workflows = null;
            return;
        }
        this.workflows = new ArrayList<ListedWorkflow>(workflows);
    }

    public ListWorkflowsResult withWorkflows(ListedWorkflow ... workflows) {
        if (this.workflows == null) {
            this.setWorkflows(new ArrayList<ListedWorkflow>(workflows.length));
        }
        for (ListedWorkflow ele : workflows) {
            this.workflows.add(ele);
        }
        return this;
    }

    public ListWorkflowsResult withWorkflows(Collection<ListedWorkflow> workflows) {
        this.setWorkflows(workflows);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getWorkflows() != null) {
            sb.append("Workflows: ").append(this.getWorkflows());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowsResult)) {
            return false;
        }
        ListWorkflowsResult other = (ListWorkflowsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getWorkflows() == null ^ this.getWorkflows() == null) {
            return false;
        }
        return other.getWorkflows() == null || other.getWorkflows().equals(this.getWorkflows());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflows() == null ? 0 : this.getWorkflows().hashCode());
        return hashCode;
    }

    public ListWorkflowsResult clone() {
        try {
            return (ListWorkflowsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

