/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transfer.model.HomeDirectoryMapEntry;
import com.amazonaws.services.transfer.model.HomeDirectoryType;
import com.amazonaws.services.transfer.model.SshPublicKey;
import com.amazonaws.services.transfer.model.Tag;
import com.amazonaws.services.transfer.model.transform.DescribedUserMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribedUser
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String homeDirectory;
    private List<HomeDirectoryMapEntry> homeDirectoryMappings;
    private String homeDirectoryType;
    private String policy;
    private String role;
    private List<SshPublicKey> sshPublicKeys;
    private List<Tag> tags;
    private String userName;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public DescribedUser withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public DescribedUser withHomeDirectory(String homeDirectory) {
        this.setHomeDirectory(homeDirectory);
        return this;
    }

    public List<HomeDirectoryMapEntry> getHomeDirectoryMappings() {
        return this.homeDirectoryMappings;
    }

    public void setHomeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings) {
        if (homeDirectoryMappings == null) {
            this.homeDirectoryMappings = null;
            return;
        }
        this.homeDirectoryMappings = new ArrayList<HomeDirectoryMapEntry>(homeDirectoryMappings);
    }

    public DescribedUser withHomeDirectoryMappings(HomeDirectoryMapEntry ... homeDirectoryMappings) {
        if (this.homeDirectoryMappings == null) {
            this.setHomeDirectoryMappings(new ArrayList<HomeDirectoryMapEntry>(homeDirectoryMappings.length));
        }
        for (HomeDirectoryMapEntry ele : homeDirectoryMappings) {
            this.homeDirectoryMappings.add(ele);
        }
        return this;
    }

    public DescribedUser withHomeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings) {
        this.setHomeDirectoryMappings(homeDirectoryMappings);
        return this;
    }

    public void setHomeDirectoryType(String homeDirectoryType) {
        this.homeDirectoryType = homeDirectoryType;
    }

    public String getHomeDirectoryType() {
        return this.homeDirectoryType;
    }

    public DescribedUser withHomeDirectoryType(String homeDirectoryType) {
        this.setHomeDirectoryType(homeDirectoryType);
        return this;
    }

    public DescribedUser withHomeDirectoryType(HomeDirectoryType homeDirectoryType) {
        this.homeDirectoryType = homeDirectoryType.toString();
        return this;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getPolicy() {
        return this.policy;
    }

    public DescribedUser withPolicy(String policy) {
        this.setPolicy(policy);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public DescribedUser withRole(String role) {
        this.setRole(role);
        return this;
    }

    public List<SshPublicKey> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    public void setSshPublicKeys(Collection<SshPublicKey> sshPublicKeys) {
        if (sshPublicKeys == null) {
            this.sshPublicKeys = null;
            return;
        }
        this.sshPublicKeys = new ArrayList<SshPublicKey>(sshPublicKeys);
    }

    public DescribedUser withSshPublicKeys(SshPublicKey ... sshPublicKeys) {
        if (this.sshPublicKeys == null) {
            this.setSshPublicKeys(new ArrayList<SshPublicKey>(sshPublicKeys.length));
        }
        for (SshPublicKey ele : sshPublicKeys) {
            this.sshPublicKeys.add(ele);
        }
        return this;
    }

    public DescribedUser withSshPublicKeys(Collection<SshPublicKey> sshPublicKeys) {
        this.setSshPublicKeys(sshPublicKeys);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public DescribedUser withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public DescribedUser withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public DescribedUser withUserName(String userName) {
        this.setUserName(userName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getHomeDirectory() != null) {
            sb.append("HomeDirectory: ").append(this.getHomeDirectory()).append(",");
        }
        if (this.getHomeDirectoryMappings() != null) {
            sb.append("HomeDirectoryMappings: ").append(this.getHomeDirectoryMappings()).append(",");
        }
        if (this.getHomeDirectoryType() != null) {
            sb.append("HomeDirectoryType: ").append(this.getHomeDirectoryType()).append(",");
        }
        if (this.getPolicy() != null) {
            sb.append("Policy: ").append(this.getPolicy()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getSshPublicKeys() != null) {
            sb.append("SshPublicKeys: ").append(this.getSshPublicKeys()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getUserName() != null) {
            sb.append("UserName: ").append(this.getUserName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedUser)) {
            return false;
        }
        DescribedUser other = (DescribedUser)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getHomeDirectory() == null ^ this.getHomeDirectory() == null) {
            return false;
        }
        if (other.getHomeDirectory() != null && !other.getHomeDirectory().equals(this.getHomeDirectory())) {
            return false;
        }
        if (other.getHomeDirectoryMappings() == null ^ this.getHomeDirectoryMappings() == null) {
            return false;
        }
        if (other.getHomeDirectoryMappings() != null && !other.getHomeDirectoryMappings().equals(this.getHomeDirectoryMappings())) {
            return false;
        }
        if (other.getHomeDirectoryType() == null ^ this.getHomeDirectoryType() == null) {
            return false;
        }
        if (other.getHomeDirectoryType() != null && !other.getHomeDirectoryType().equals(this.getHomeDirectoryType())) {
            return false;
        }
        if (other.getPolicy() == null ^ this.getPolicy() == null) {
            return false;
        }
        if (other.getPolicy() != null && !other.getPolicy().equals(this.getPolicy())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getSshPublicKeys() == null ^ this.getSshPublicKeys() == null) {
            return false;
        }
        if (other.getSshPublicKeys() != null && !other.getSshPublicKeys().equals(this.getSshPublicKeys())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getUserName() == null ^ this.getUserName() == null) {
            return false;
        }
        return other.getUserName() == null || other.getUserName().equals(this.getUserName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getHomeDirectory() == null ? 0 : this.getHomeDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getHomeDirectoryMappings() == null ? 0 : this.getHomeDirectoryMappings().hashCode());
        hashCode = 31 * hashCode + (this.getHomeDirectoryType() == null ? 0 : this.getHomeDirectoryType().hashCode());
        hashCode = 31 * hashCode + (this.getPolicy() == null ? 0 : this.getPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getSshPublicKeys() == null ? 0 : this.getSshPublicKeys().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        return hashCode;
    }

    public DescribedUser clone() {
        try {
            return (DescribedUser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DescribedUserMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

