/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.transfer.model.EndpointDetails;
import java.util.List;

@SdkInternalApi
public class EndpointDetailsMarshaller {
    private static final MarshallingInfo<List> ADDRESSALLOCATIONIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressAllocationIds").build();
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIds").build();
    private static final MarshallingInfo<String> VPCENDPOINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcEndpointId").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").build();
    private static final EndpointDetailsMarshaller instance = new EndpointDetailsMarshaller();

    public static EndpointDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(EndpointDetails endpointDetails, ProtocolMarshaller protocolMarshaller) {
        if (endpointDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(endpointDetails.getAddressAllocationIds(), ADDRESSALLOCATIONIDS_BINDING);
            protocolMarshaller.marshall(endpointDetails.getSubnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall((Object)endpointDetails.getVpcEndpointId(), VPCENDPOINTID_BINDING);
            protocolMarshaller.marshall((Object)endpointDetails.getVpcId(), VPCID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

