/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.transcribe.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Allows additional optional settings in your request, including channel identification, alternative transcriptions,
 * and speaker partitioning. You can use that to apply custom vocabularies to your medical transcription job.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/MedicalTranscriptionSetting"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MedicalTranscriptionSetting implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech
     * from individual speakers in your media file.
     * </p>
     * <p>
     * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>
     * .
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.
     * </p>
     */
    private Boolean showSpeakerLabels;
    /**
     * <p>
     * Specify the maximum number of speakers you want to partition in your media.
     * </p>
     * <p>
     * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a
     * single speaker.
     * </p>
     * <p>
     * If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to
     * true.
     * </p>
     */
    private Integer maxSpeakerLabels;
    /**
     * <p>
     * Enables channel identification in multi-channel audio.
     * </p>
     * <p>
     * Channel identification transcribes the audio on each channel independently, then appends the output for each
     * channel into one transcript.
     * </p>
     * <p>
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     * continuous manner and your transcript does not separate the speech by channel.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing
     * multi-channel audio</a>.
     * </p>
     */
    private Boolean channelIdentification;
    /**
     * <p>
     * To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code> in
     * your transcription request.
     * </p>
     * <p>
     * If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is the
     * maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     */
    private Boolean showAlternatives;
    /**
     * <p>
     * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in your
     * transcript.
     * </p>
     * <p>
     * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe
     * Medical, only the actual number of alternative transcriptions are included.
     * </p>
     * <p>
     * If you include <code>MaxAlternatives</code> in your request, you must also include <code>ShowAlternatives</code>
     * with a value of <code>true</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     */
    private Integer maxAlternatives;
    /**
     * <p>
     * The name of the custom vocabulary you want to use when processing your medical transcription job. Custom
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * The language of the specified custom vocabulary must match the language code that you specify in your
     * transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no errors or
     * warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid language for
     * Amazon Transcribe Medical.
     * </p>
     */
    private String vocabularyName;

    /**
     * <p>
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech
     * from individual speakers in your media file.
     * </p>
     * <p>
     * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>
     * .
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.
     * </p>
     * 
     * @param showSpeakerLabels
     *        Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
     *        speech from individual speakers in your media file.</p>
     *        <p>
     *        If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
     *        <code>MaxSpeakerLabels</code>.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
     *        (diarization)</a>.
     */

    public void setShowSpeakerLabels(Boolean showSpeakerLabels) {
        this.showSpeakerLabels = showSpeakerLabels;
    }

    /**
     * <p>
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech
     * from individual speakers in your media file.
     * </p>
     * <p>
     * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>
     * .
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.
     * </p>
     * 
     * @return Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
     *         speech from individual speakers in your media file.</p>
     *         <p>
     *         If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
     *         <code>MaxSpeakerLabels</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
     *         (diarization)</a>.
     */

    public Boolean getShowSpeakerLabels() {
        return this.showSpeakerLabels;
    }

    /**
     * <p>
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech
     * from individual speakers in your media file.
     * </p>
     * <p>
     * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>
     * .
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.
     * </p>
     * 
     * @param showSpeakerLabels
     *        Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
     *        speech from individual speakers in your media file.</p>
     *        <p>
     *        If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
     *        <code>MaxSpeakerLabels</code>.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
     *        (diarization)</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MedicalTranscriptionSetting withShowSpeakerLabels(Boolean showSpeakerLabels) {
        setShowSpeakerLabels(showSpeakerLabels);
        return this;
    }

    /**
     * <p>
     * Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech
     * from individual speakers in your media file.
     * </p>
     * <p>
     * If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>
     * .
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.
     * </p>
     * 
     * @return Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the
     *         speech from individual speakers in your media file.</p>
     *         <p>
     *         If you enable <code>ShowSpeakerLabels</code> in your request, you must also include
     *         <code>MaxSpeakerLabels</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers
     *         (diarization)</a>.
     */

    public Boolean isShowSpeakerLabels() {
        return this.showSpeakerLabels;
    }

    /**
     * <p>
     * Specify the maximum number of speakers you want to partition in your media.
     * </p>
     * <p>
     * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a
     * single speaker.
     * </p>
     * <p>
     * If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to
     * true.
     * </p>
     * 
     * @param maxSpeakerLabels
     *        Specify the maximum number of speakers you want to partition in your media.</p>
     *        <p>
     *        Note that if your media contains more speakers than the specified number, multiple speakers are treated as
     *        a single speaker.
     *        </p>
     *        <p>
     *        If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code>
     *        field to true.
     */

    public void setMaxSpeakerLabels(Integer maxSpeakerLabels) {
        this.maxSpeakerLabels = maxSpeakerLabels;
    }

    /**
     * <p>
     * Specify the maximum number of speakers you want to partition in your media.
     * </p>
     * <p>
     * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a
     * single speaker.
     * </p>
     * <p>
     * If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to
     * true.
     * </p>
     * 
     * @return Specify the maximum number of speakers you want to partition in your media.</p>
     *         <p>
     *         Note that if your media contains more speakers than the specified number, multiple speakers are treated
     *         as a single speaker.
     *         </p>
     *         <p>
     *         If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code>
     *         field to true.
     */

    public Integer getMaxSpeakerLabels() {
        return this.maxSpeakerLabels;
    }

    /**
     * <p>
     * Specify the maximum number of speakers you want to partition in your media.
     * </p>
     * <p>
     * Note that if your media contains more speakers than the specified number, multiple speakers are treated as a
     * single speaker.
     * </p>
     * <p>
     * If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to
     * true.
     * </p>
     * 
     * @param maxSpeakerLabels
     *        Specify the maximum number of speakers you want to partition in your media.</p>
     *        <p>
     *        Note that if your media contains more speakers than the specified number, multiple speakers are treated as
     *        a single speaker.
     *        </p>
     *        <p>
     *        If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code>
     *        field to true.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MedicalTranscriptionSetting withMaxSpeakerLabels(Integer maxSpeakerLabels) {
        setMaxSpeakerLabels(maxSpeakerLabels);
        return this;
    }

    /**
     * <p>
     * Enables channel identification in multi-channel audio.
     * </p>
     * <p>
     * Channel identification transcribes the audio on each channel independently, then appends the output for each
     * channel into one transcript.
     * </p>
     * <p>
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     * continuous manner and your transcript does not separate the speech by channel.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing
     * multi-channel audio</a>.
     * </p>
     * 
     * @param channelIdentification
     *        Enables channel identification in multi-channel audio.</p>
     *        <p>
     *        Channel identification transcribes the audio on each channel independently, then appends the output for
     *        each channel into one transcript.
     *        </p>
     *        <p>
     *        If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     *        continuous manner and your transcript does not separate the speech by channel.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
     *        audio</a>.
     */

    public void setChannelIdentification(Boolean channelIdentification) {
        this.channelIdentification = channelIdentification;
    }

    /**
     * <p>
     * Enables channel identification in multi-channel audio.
     * </p>
     * <p>
     * Channel identification transcribes the audio on each channel independently, then appends the output for each
     * channel into one transcript.
     * </p>
     * <p>
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     * continuous manner and your transcript does not separate the speech by channel.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing
     * multi-channel audio</a>.
     * </p>
     * 
     * @return Enables channel identification in multi-channel audio.</p>
     *         <p>
     *         Channel identification transcribes the audio on each channel independently, then appends the output for
     *         each channel into one transcript.
     *         </p>
     *         <p>
     *         If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     *         continuous manner and your transcript does not separate the speech by channel.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
     *         audio</a>.
     */

    public Boolean getChannelIdentification() {
        return this.channelIdentification;
    }

    /**
     * <p>
     * Enables channel identification in multi-channel audio.
     * </p>
     * <p>
     * Channel identification transcribes the audio on each channel independently, then appends the output for each
     * channel into one transcript.
     * </p>
     * <p>
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     * continuous manner and your transcript does not separate the speech by channel.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing
     * multi-channel audio</a>.
     * </p>
     * 
     * @param channelIdentification
     *        Enables channel identification in multi-channel audio.</p>
     *        <p>
     *        Channel identification transcribes the audio on each channel independently, then appends the output for
     *        each channel into one transcript.
     *        </p>
     *        <p>
     *        If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     *        continuous manner and your transcript does not separate the speech by channel.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
     *        audio</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MedicalTranscriptionSetting withChannelIdentification(Boolean channelIdentification) {
        setChannelIdentification(channelIdentification);
        return this;
    }

    /**
     * <p>
     * Enables channel identification in multi-channel audio.
     * </p>
     * <p>
     * Channel identification transcribes the audio on each channel independently, then appends the output for each
     * channel into one transcript.
     * </p>
     * <p>
     * If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     * continuous manner and your transcript does not separate the speech by channel.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing
     * multi-channel audio</a>.
     * </p>
     * 
     * @return Enables channel identification in multi-channel audio.</p>
     *         <p>
     *         Channel identification transcribes the audio on each channel independently, then appends the output for
     *         each channel into one transcript.
     *         </p>
     *         <p>
     *         If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a
     *         continuous manner and your transcript does not separate the speech by channel.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel
     *         audio</a>.
     */

    public Boolean isChannelIdentification() {
        return this.channelIdentification;
    }

    /**
     * <p>
     * To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code> in
     * your transcription request.
     * </p>
     * <p>
     * If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is the
     * maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @param showAlternatives
     *        To include alternative transcriptions within your transcription output, include
     *        <code>ShowAlternatives</code> in your transcription request.</p>
     *        <p>
     *        If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is
     *        the maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *        transcriptions</a>.
     */

    public void setShowAlternatives(Boolean showAlternatives) {
        this.showAlternatives = showAlternatives;
    }

    /**
     * <p>
     * To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code> in
     * your transcription request.
     * </p>
     * <p>
     * If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is the
     * maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @return To include alternative transcriptions within your transcription output, include
     *         <code>ShowAlternatives</code> in your transcription request.</p>
     *         <p>
     *         If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which
     *         is the maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *         transcriptions</a>.
     */

    public Boolean getShowAlternatives() {
        return this.showAlternatives;
    }

    /**
     * <p>
     * To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code> in
     * your transcription request.
     * </p>
     * <p>
     * If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is the
     * maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @param showAlternatives
     *        To include alternative transcriptions within your transcription output, include
     *        <code>ShowAlternatives</code> in your transcription request.</p>
     *        <p>
     *        If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is
     *        the maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *        transcriptions</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MedicalTranscriptionSetting withShowAlternatives(Boolean showAlternatives) {
        setShowAlternatives(showAlternatives);
        return this;
    }

    /**
     * <p>
     * To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code> in
     * your transcription request.
     * </p>
     * <p>
     * If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is the
     * maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @return To include alternative transcriptions within your transcription output, include
     *         <code>ShowAlternatives</code> in your transcription request.</p>
     *         <p>
     *         If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which
     *         is the maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *         transcriptions</a>.
     */

    public Boolean isShowAlternatives() {
        return this.showAlternatives;
    }

    /**
     * <p>
     * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in your
     * transcript.
     * </p>
     * <p>
     * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe
     * Medical, only the actual number of alternative transcriptions are included.
     * </p>
     * <p>
     * If you include <code>MaxAlternatives</code> in your request, you must also include <code>ShowAlternatives</code>
     * with a value of <code>true</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @param maxAlternatives
     *        Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in
     *        your transcript.</p>
     *        <p>
     *        If you select a number greater than the number of alternative transcriptions generated by Amazon
     *        Transcribe Medical, only the actual number of alternative transcriptions are included.
     *        </p>
     *        <p>
     *        If you include <code>MaxAlternatives</code> in your request, you must also include
     *        <code>ShowAlternatives</code> with a value of <code>true</code>.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *        transcriptions</a>.
     */

    public void setMaxAlternatives(Integer maxAlternatives) {
        this.maxAlternatives = maxAlternatives;
    }

    /**
     * <p>
     * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in your
     * transcript.
     * </p>
     * <p>
     * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe
     * Medical, only the actual number of alternative transcriptions are included.
     * </p>
     * <p>
     * If you include <code>MaxAlternatives</code> in your request, you must also include <code>ShowAlternatives</code>
     * with a value of <code>true</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @return Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include
     *         in your transcript.</p>
     *         <p>
     *         If you select a number greater than the number of alternative transcriptions generated by Amazon
     *         Transcribe Medical, only the actual number of alternative transcriptions are included.
     *         </p>
     *         <p>
     *         If you include <code>MaxAlternatives</code> in your request, you must also include
     *         <code>ShowAlternatives</code> with a value of <code>true</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *         transcriptions</a>.
     */

    public Integer getMaxAlternatives() {
        return this.maxAlternatives;
    }

    /**
     * <p>
     * Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in your
     * transcript.
     * </p>
     * <p>
     * If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe
     * Medical, only the actual number of alternative transcriptions are included.
     * </p>
     * <p>
     * If you include <code>MaxAlternatives</code> in your request, you must also include <code>ShowAlternatives</code>
     * with a value of <code>true</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.
     * </p>
     * 
     * @param maxAlternatives
     *        Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in
     *        your transcript.</p>
     *        <p>
     *        If you select a number greater than the number of alternative transcriptions generated by Amazon
     *        Transcribe Medical, only the actual number of alternative transcriptions are included.
     *        </p>
     *        <p>
     *        If you include <code>MaxAlternatives</code> in your request, you must also include
     *        <code>ShowAlternatives</code> with a value of <code>true</code>.
     *        </p>
     *        <p>
     *        For more information, see <a
     *        href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative
     *        transcriptions</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MedicalTranscriptionSetting withMaxAlternatives(Integer maxAlternatives) {
        setMaxAlternatives(maxAlternatives);
        return this;
    }

    /**
     * <p>
     * The name of the custom vocabulary you want to use when processing your medical transcription job. Custom
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * The language of the specified custom vocabulary must match the language code that you specify in your
     * transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no errors or
     * warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid language for
     * Amazon Transcribe Medical.
     * </p>
     * 
     * @param vocabularyName
     *        The name of the custom vocabulary you want to use when processing your medical transcription job. Custom
     *        vocabulary names are case sensitive.</p>
     *        <p>
     *        The language of the specified custom vocabulary must match the language code that you specify in your
     *        transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no
     *        errors or warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid
     *        language for Amazon Transcribe Medical.
     */

    public void setVocabularyName(String vocabularyName) {
        this.vocabularyName = vocabularyName;
    }

    /**
     * <p>
     * The name of the custom vocabulary you want to use when processing your medical transcription job. Custom
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * The language of the specified custom vocabulary must match the language code that you specify in your
     * transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no errors or
     * warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid language for
     * Amazon Transcribe Medical.
     * </p>
     * 
     * @return The name of the custom vocabulary you want to use when processing your medical transcription job. Custom
     *         vocabulary names are case sensitive.</p>
     *         <p>
     *         The language of the specified custom vocabulary must match the language code that you specify in your
     *         transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no
     *         errors or warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid
     *         language for Amazon Transcribe Medical.
     */

    public String getVocabularyName() {
        return this.vocabularyName;
    }

    /**
     * <p>
     * The name of the custom vocabulary you want to use when processing your medical transcription job. Custom
     * vocabulary names are case sensitive.
     * </p>
     * <p>
     * The language of the specified custom vocabulary must match the language code that you specify in your
     * transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no errors or
     * warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid language for
     * Amazon Transcribe Medical.
     * </p>
     * 
     * @param vocabularyName
     *        The name of the custom vocabulary you want to use when processing your medical transcription job. Custom
     *        vocabulary names are case sensitive.</p>
     *        <p>
     *        The language of the specified custom vocabulary must match the language code that you specify in your
     *        transcription request. If the languages do not match, the custom vocabulary isn't applied. There are no
     *        errors or warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid
     *        language for Amazon Transcribe Medical.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MedicalTranscriptionSetting withVocabularyName(String vocabularyName) {
        setVocabularyName(vocabularyName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getShowSpeakerLabels() != null)
            sb.append("ShowSpeakerLabels: ").append(getShowSpeakerLabels()).append(",");
        if (getMaxSpeakerLabels() != null)
            sb.append("MaxSpeakerLabels: ").append(getMaxSpeakerLabels()).append(",");
        if (getChannelIdentification() != null)
            sb.append("ChannelIdentification: ").append(getChannelIdentification()).append(",");
        if (getShowAlternatives() != null)
            sb.append("ShowAlternatives: ").append(getShowAlternatives()).append(",");
        if (getMaxAlternatives() != null)
            sb.append("MaxAlternatives: ").append(getMaxAlternatives()).append(",");
        if (getVocabularyName() != null)
            sb.append("VocabularyName: ").append(getVocabularyName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MedicalTranscriptionSetting == false)
            return false;
        MedicalTranscriptionSetting other = (MedicalTranscriptionSetting) obj;
        if (other.getShowSpeakerLabels() == null ^ this.getShowSpeakerLabels() == null)
            return false;
        if (other.getShowSpeakerLabels() != null && other.getShowSpeakerLabels().equals(this.getShowSpeakerLabels()) == false)
            return false;
        if (other.getMaxSpeakerLabels() == null ^ this.getMaxSpeakerLabels() == null)
            return false;
        if (other.getMaxSpeakerLabels() != null && other.getMaxSpeakerLabels().equals(this.getMaxSpeakerLabels()) == false)
            return false;
        if (other.getChannelIdentification() == null ^ this.getChannelIdentification() == null)
            return false;
        if (other.getChannelIdentification() != null && other.getChannelIdentification().equals(this.getChannelIdentification()) == false)
            return false;
        if (other.getShowAlternatives() == null ^ this.getShowAlternatives() == null)
            return false;
        if (other.getShowAlternatives() != null && other.getShowAlternatives().equals(this.getShowAlternatives()) == false)
            return false;
        if (other.getMaxAlternatives() == null ^ this.getMaxAlternatives() == null)
            return false;
        if (other.getMaxAlternatives() != null && other.getMaxAlternatives().equals(this.getMaxAlternatives()) == false)
            return false;
        if (other.getVocabularyName() == null ^ this.getVocabularyName() == null)
            return false;
        if (other.getVocabularyName() != null && other.getVocabularyName().equals(this.getVocabularyName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getShowSpeakerLabels() == null) ? 0 : getShowSpeakerLabels().hashCode());
        hashCode = prime * hashCode + ((getMaxSpeakerLabels() == null) ? 0 : getMaxSpeakerLabels().hashCode());
        hashCode = prime * hashCode + ((getChannelIdentification() == null) ? 0 : getChannelIdentification().hashCode());
        hashCode = prime * hashCode + ((getShowAlternatives() == null) ? 0 : getShowAlternatives().hashCode());
        hashCode = prime * hashCode + ((getMaxAlternatives() == null) ? 0 : getMaxAlternatives().hashCode());
        hashCode = prime * hashCode + ((getVocabularyName() == null) ? 0 : getVocabularyName().hashCode());
        return hashCode;
    }

    @Override
    public MedicalTranscriptionSetting clone() {
        try {
            return (MedicalTranscriptionSetting) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.transcribe.model.transform.MedicalTranscriptionSettingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
