/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.transcribe.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides information on the speech contained in a discreet utterance when multi-language identification is enabled in
 * your request. This utterance represents a block of speech consisting of one language, preceded or followed by a block
 * of speech in a different language.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/LanguageCodeItem" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class LanguageCodeItem implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Provides the language code for each language identified in your media.
     * </p>
     */
    private String languageCode;
    /**
     * <p>
     * Provides the total time, in seconds, each identified language is spoken in your media.
     * </p>
     */
    private Float durationInSeconds;

    /**
     * <p>
     * Provides the language code for each language identified in your media.
     * </p>
     * 
     * @param languageCode
     *        Provides the language code for each language identified in your media.
     * @see LanguageCode
     */

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    /**
     * <p>
     * Provides the language code for each language identified in your media.
     * </p>
     * 
     * @return Provides the language code for each language identified in your media.
     * @see LanguageCode
     */

    public String getLanguageCode() {
        return this.languageCode;
    }

    /**
     * <p>
     * Provides the language code for each language identified in your media.
     * </p>
     * 
     * @param languageCode
     *        Provides the language code for each language identified in your media.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LanguageCode
     */

    public LanguageCodeItem withLanguageCode(String languageCode) {
        setLanguageCode(languageCode);
        return this;
    }

    /**
     * <p>
     * Provides the language code for each language identified in your media.
     * </p>
     * 
     * @param languageCode
     *        Provides the language code for each language identified in your media.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LanguageCode
     */

    public LanguageCodeItem withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    /**
     * <p>
     * Provides the total time, in seconds, each identified language is spoken in your media.
     * </p>
     * 
     * @param durationInSeconds
     *        Provides the total time, in seconds, each identified language is spoken in your media.
     */

    public void setDurationInSeconds(Float durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
    }

    /**
     * <p>
     * Provides the total time, in seconds, each identified language is spoken in your media.
     * </p>
     * 
     * @return Provides the total time, in seconds, each identified language is spoken in your media.
     */

    public Float getDurationInSeconds() {
        return this.durationInSeconds;
    }

    /**
     * <p>
     * Provides the total time, in seconds, each identified language is spoken in your media.
     * </p>
     * 
     * @param durationInSeconds
     *        Provides the total time, in seconds, each identified language is spoken in your media.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public LanguageCodeItem withDurationInSeconds(Float durationInSeconds) {
        setDurationInSeconds(durationInSeconds);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getLanguageCode() != null)
            sb.append("LanguageCode: ").append(getLanguageCode()).append(",");
        if (getDurationInSeconds() != null)
            sb.append("DurationInSeconds: ").append(getDurationInSeconds());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof LanguageCodeItem == false)
            return false;
        LanguageCodeItem other = (LanguageCodeItem) obj;
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null)
            return false;
        if (other.getLanguageCode() != null && other.getLanguageCode().equals(this.getLanguageCode()) == false)
            return false;
        if (other.getDurationInSeconds() == null ^ this.getDurationInSeconds() == null)
            return false;
        if (other.getDurationInSeconds() != null && other.getDurationInSeconds().equals(this.getDurationInSeconds()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getLanguageCode() == null) ? 0 : getLanguageCode().hashCode());
        hashCode = prime * hashCode + ((getDurationInSeconds() == null) ? 0 : getDurationInSeconds().hashCode());
        return hashCode;
    }

    @Override
    public LanguageCodeItem clone() {
        try {
            return (LanguageCodeItem) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.transcribe.model.transform.LanguageCodeItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
