/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transcribe.model.LanguageCode;
import com.amazonaws.services.transcribe.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateVocabularyFilterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String vocabularyFilterName;
    private String languageCode;
    private List<String> words;
    private String vocabularyFilterFileUri;
    private List<Tag> tags;
    private String dataAccessRoleArn;

    public void setVocabularyFilterName(String vocabularyFilterName) {
        this.vocabularyFilterName = vocabularyFilterName;
    }

    public String getVocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public CreateVocabularyFilterRequest withVocabularyFilterName(String vocabularyFilterName) {
        this.setVocabularyFilterName(vocabularyFilterName);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public CreateVocabularyFilterRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public CreateVocabularyFilterRequest withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public List<String> getWords() {
        return this.words;
    }

    public void setWords(Collection<String> words) {
        if (words == null) {
            this.words = null;
            return;
        }
        this.words = new ArrayList<String>(words);
    }

    public CreateVocabularyFilterRequest withWords(String ... words) {
        if (this.words == null) {
            this.setWords(new ArrayList<String>(words.length));
        }
        for (String ele : words) {
            this.words.add(ele);
        }
        return this;
    }

    public CreateVocabularyFilterRequest withWords(Collection<String> words) {
        this.setWords(words);
        return this;
    }

    public void setVocabularyFilterFileUri(String vocabularyFilterFileUri) {
        this.vocabularyFilterFileUri = vocabularyFilterFileUri;
    }

    public String getVocabularyFilterFileUri() {
        return this.vocabularyFilterFileUri;
    }

    public CreateVocabularyFilterRequest withVocabularyFilterFileUri(String vocabularyFilterFileUri) {
        this.setVocabularyFilterFileUri(vocabularyFilterFileUri);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateVocabularyFilterRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateVocabularyFilterRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setDataAccessRoleArn(String dataAccessRoleArn) {
        this.dataAccessRoleArn = dataAccessRoleArn;
    }

    public String getDataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public CreateVocabularyFilterRequest withDataAccessRoleArn(String dataAccessRoleArn) {
        this.setDataAccessRoleArn(dataAccessRoleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVocabularyFilterName() != null) {
            sb.append("VocabularyFilterName: ").append(this.getVocabularyFilterName()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getWords() != null) {
            sb.append("Words: ").append(this.getWords()).append(",");
        }
        if (this.getVocabularyFilterFileUri() != null) {
            sb.append("VocabularyFilterFileUri: ").append(this.getVocabularyFilterFileUri()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getDataAccessRoleArn() != null) {
            sb.append("DataAccessRoleArn: ").append(this.getDataAccessRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVocabularyFilterRequest)) {
            return false;
        }
        CreateVocabularyFilterRequest other = (CreateVocabularyFilterRequest)obj;
        if (other.getVocabularyFilterName() == null ^ this.getVocabularyFilterName() == null) {
            return false;
        }
        if (other.getVocabularyFilterName() != null && !other.getVocabularyFilterName().equals(this.getVocabularyFilterName())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getWords() == null ^ this.getWords() == null) {
            return false;
        }
        if (other.getWords() != null && !other.getWords().equals(this.getWords())) {
            return false;
        }
        if (other.getVocabularyFilterFileUri() == null ^ this.getVocabularyFilterFileUri() == null) {
            return false;
        }
        if (other.getVocabularyFilterFileUri() != null && !other.getVocabularyFilterFileUri().equals(this.getVocabularyFilterFileUri())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getDataAccessRoleArn() == null ^ this.getDataAccessRoleArn() == null) {
            return false;
        }
        return other.getDataAccessRoleArn() == null || other.getDataAccessRoleArn().equals(this.getDataAccessRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVocabularyFilterName() == null ? 0 : this.getVocabularyFilterName().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getWords() == null ? 0 : this.getWords().hashCode());
        hashCode = 31 * hashCode + (this.getVocabularyFilterFileUri() == null ? 0 : this.getVocabularyFilterFileUri().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getDataAccessRoleArn() == null ? 0 : this.getDataAccessRoleArn().hashCode());
        return hashCode;
    }

    public CreateVocabularyFilterRequest clone() {
        return (CreateVocabularyFilterRequest)super.clone();
    }
}

