/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.transcribe.AmazonTranscribeAsync;
import com.amazonaws.services.transcribe.AmazonTranscribeAsyncClientBuilder;
import com.amazonaws.services.transcribe.AmazonTranscribeClient;
import com.amazonaws.services.transcribe.model.CreateVocabularyRequest;
import com.amazonaws.services.transcribe.model.CreateVocabularyResult;
import com.amazonaws.services.transcribe.model.DeleteVocabularyRequest;
import com.amazonaws.services.transcribe.model.DeleteVocabularyResult;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.GetVocabularyRequest;
import com.amazonaws.services.transcribe.model.GetVocabularyResult;
import com.amazonaws.services.transcribe.model.ListTranscriptionJobsRequest;
import com.amazonaws.services.transcribe.model.ListTranscriptionJobsResult;
import com.amazonaws.services.transcribe.model.ListVocabulariesRequest;
import com.amazonaws.services.transcribe.model.ListVocabulariesResult;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.UpdateVocabularyRequest;
import com.amazonaws.services.transcribe.model.UpdateVocabularyResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonTranscribeAsyncClient
extends AmazonTranscribeClient
implements AmazonTranscribeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonTranscribeAsyncClientBuilder asyncBuilder() {
        return AmazonTranscribeAsyncClientBuilder.standard();
    }

    AmazonTranscribeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateVocabularyResult> createVocabularyAsync(CreateVocabularyRequest request) {
        return this.createVocabularyAsync(request, null);
    }

    @Override
    public Future<CreateVocabularyResult> createVocabularyAsync(CreateVocabularyRequest request, final AsyncHandler<CreateVocabularyRequest, CreateVocabularyResult> asyncHandler) {
        final CreateVocabularyRequest finalRequest = (CreateVocabularyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVocabularyResult>(){

            @Override
            public CreateVocabularyResult call() throws Exception {
                CreateVocabularyResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.executeCreateVocabulary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVocabularyResult> deleteVocabularyAsync(DeleteVocabularyRequest request) {
        return this.deleteVocabularyAsync(request, null);
    }

    @Override
    public Future<DeleteVocabularyResult> deleteVocabularyAsync(DeleteVocabularyRequest request, final AsyncHandler<DeleteVocabularyRequest, DeleteVocabularyResult> asyncHandler) {
        final DeleteVocabularyRequest finalRequest = (DeleteVocabularyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVocabularyResult>(){

            @Override
            public DeleteVocabularyResult call() throws Exception {
                DeleteVocabularyResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.executeDeleteVocabulary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTranscriptionJobResult> getTranscriptionJobAsync(GetTranscriptionJobRequest request) {
        return this.getTranscriptionJobAsync(request, null);
    }

    @Override
    public Future<GetTranscriptionJobResult> getTranscriptionJobAsync(GetTranscriptionJobRequest request, final AsyncHandler<GetTranscriptionJobRequest, GetTranscriptionJobResult> asyncHandler) {
        final GetTranscriptionJobRequest finalRequest = (GetTranscriptionJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTranscriptionJobResult>(){

            @Override
            public GetTranscriptionJobResult call() throws Exception {
                GetTranscriptionJobResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.executeGetTranscriptionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetVocabularyResult> getVocabularyAsync(GetVocabularyRequest request) {
        return this.getVocabularyAsync(request, null);
    }

    @Override
    public Future<GetVocabularyResult> getVocabularyAsync(GetVocabularyRequest request, final AsyncHandler<GetVocabularyRequest, GetVocabularyResult> asyncHandler) {
        final GetVocabularyRequest finalRequest = (GetVocabularyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetVocabularyResult>(){

            @Override
            public GetVocabularyResult call() throws Exception {
                GetVocabularyResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.executeGetVocabulary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTranscriptionJobsResult> listTranscriptionJobsAsync(ListTranscriptionJobsRequest request) {
        return this.listTranscriptionJobsAsync(request, null);
    }

    @Override
    public Future<ListTranscriptionJobsResult> listTranscriptionJobsAsync(ListTranscriptionJobsRequest request, final AsyncHandler<ListTranscriptionJobsRequest, ListTranscriptionJobsResult> asyncHandler) {
        final ListTranscriptionJobsRequest finalRequest = (ListTranscriptionJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTranscriptionJobsResult>(){

            @Override
            public ListTranscriptionJobsResult call() throws Exception {
                ListTranscriptionJobsResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.executeListTranscriptionJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVocabulariesResult> listVocabulariesAsync(ListVocabulariesRequest request) {
        return this.listVocabulariesAsync(request, null);
    }

    @Override
    public Future<ListVocabulariesResult> listVocabulariesAsync(ListVocabulariesRequest request, final AsyncHandler<ListVocabulariesRequest, ListVocabulariesResult> asyncHandler) {
        final ListVocabulariesRequest finalRequest = (ListVocabulariesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListVocabulariesResult>(){

            @Override
            public ListVocabulariesResult call() throws Exception {
                ListVocabulariesResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.executeListVocabularies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartTranscriptionJobResult> startTranscriptionJobAsync(StartTranscriptionJobRequest request) {
        return this.startTranscriptionJobAsync(request, null);
    }

    @Override
    public Future<StartTranscriptionJobResult> startTranscriptionJobAsync(StartTranscriptionJobRequest request, final AsyncHandler<StartTranscriptionJobRequest, StartTranscriptionJobResult> asyncHandler) {
        final StartTranscriptionJobRequest finalRequest = (StartTranscriptionJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartTranscriptionJobResult>(){

            @Override
            public StartTranscriptionJobResult call() throws Exception {
                StartTranscriptionJobResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.executeStartTranscriptionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVocabularyResult> updateVocabularyAsync(UpdateVocabularyRequest request) {
        return this.updateVocabularyAsync(request, null);
    }

    @Override
    public Future<UpdateVocabularyResult> updateVocabularyAsync(UpdateVocabularyRequest request, final AsyncHandler<UpdateVocabularyRequest, UpdateVocabularyResult> asyncHandler) {
        final UpdateVocabularyRequest finalRequest = (UpdateVocabularyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateVocabularyResult>(){

            @Override
            public UpdateVocabularyResult call() throws Exception {
                UpdateVocabularyResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.executeUpdateVocabulary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

