/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.tnb.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about a function package.
 * </p>
 * <p>
 * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI
 * standard telecommunication application) and function package descriptor that uses the TOSCA standard to describe how
 * the network functions should run on your network.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackageInfo" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListSolFunctionPackageInfo implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Function package ARN.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * ID of the function package.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The metadata of the function package.
     * </p>
     */
    private ListSolFunctionPackageMetadata metadata;
    /**
     * <p>
     * Onboarding state of the function package.
     * </p>
     */
    private String onboardingState;
    /**
     * <p>
     * Operational state of the function package.
     * </p>
     */
    private String operationalState;
    /**
     * <p>
     * Usage state of the function package.
     * </p>
     */
    private String usageState;
    /**
     * <p>
     * The product name for the network function.
     * </p>
     */
    private String vnfProductName;
    /**
     * <p>
     * Provider of the function package and the function package descriptor.
     * </p>
     */
    private String vnfProvider;
    /**
     * <p>
     * Identifies the function package and the function package descriptor.
     * </p>
     */
    private String vnfdId;
    /**
     * <p>
     * Identifies the version of the function package descriptor.
     * </p>
     */
    private String vnfdVersion;

    /**
     * <p>
     * Function package ARN.
     * </p>
     * 
     * @param arn
     *        Function package ARN.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * Function package ARN.
     * </p>
     * 
     * @return Function package ARN.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * Function package ARN.
     * </p>
     * 
     * @param arn
     *        Function package ARN.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSolFunctionPackageInfo withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * ID of the function package.
     * </p>
     * 
     * @param id
     *        ID of the function package.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * ID of the function package.
     * </p>
     * 
     * @return ID of the function package.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * ID of the function package.
     * </p>
     * 
     * @param id
     *        ID of the function package.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSolFunctionPackageInfo withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The metadata of the function package.
     * </p>
     * 
     * @param metadata
     *        The metadata of the function package.
     */

    public void setMetadata(ListSolFunctionPackageMetadata metadata) {
        this.metadata = metadata;
    }

    /**
     * <p>
     * The metadata of the function package.
     * </p>
     * 
     * @return The metadata of the function package.
     */

    public ListSolFunctionPackageMetadata getMetadata() {
        return this.metadata;
    }

    /**
     * <p>
     * The metadata of the function package.
     * </p>
     * 
     * @param metadata
     *        The metadata of the function package.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSolFunctionPackageInfo withMetadata(ListSolFunctionPackageMetadata metadata) {
        setMetadata(metadata);
        return this;
    }

    /**
     * <p>
     * Onboarding state of the function package.
     * </p>
     * 
     * @param onboardingState
     *        Onboarding state of the function package.
     * @see OnboardingState
     */

    public void setOnboardingState(String onboardingState) {
        this.onboardingState = onboardingState;
    }

    /**
     * <p>
     * Onboarding state of the function package.
     * </p>
     * 
     * @return Onboarding state of the function package.
     * @see OnboardingState
     */

    public String getOnboardingState() {
        return this.onboardingState;
    }

    /**
     * <p>
     * Onboarding state of the function package.
     * </p>
     * 
     * @param onboardingState
     *        Onboarding state of the function package.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see OnboardingState
     */

    public ListSolFunctionPackageInfo withOnboardingState(String onboardingState) {
        setOnboardingState(onboardingState);
        return this;
    }

    /**
     * <p>
     * Onboarding state of the function package.
     * </p>
     * 
     * @param onboardingState
     *        Onboarding state of the function package.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see OnboardingState
     */

    public ListSolFunctionPackageInfo withOnboardingState(OnboardingState onboardingState) {
        this.onboardingState = onboardingState.toString();
        return this;
    }

    /**
     * <p>
     * Operational state of the function package.
     * </p>
     * 
     * @param operationalState
     *        Operational state of the function package.
     * @see OperationalState
     */

    public void setOperationalState(String operationalState) {
        this.operationalState = operationalState;
    }

    /**
     * <p>
     * Operational state of the function package.
     * </p>
     * 
     * @return Operational state of the function package.
     * @see OperationalState
     */

    public String getOperationalState() {
        return this.operationalState;
    }

    /**
     * <p>
     * Operational state of the function package.
     * </p>
     * 
     * @param operationalState
     *        Operational state of the function package.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see OperationalState
     */

    public ListSolFunctionPackageInfo withOperationalState(String operationalState) {
        setOperationalState(operationalState);
        return this;
    }

    /**
     * <p>
     * Operational state of the function package.
     * </p>
     * 
     * @param operationalState
     *        Operational state of the function package.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see OperationalState
     */

    public ListSolFunctionPackageInfo withOperationalState(OperationalState operationalState) {
        this.operationalState = operationalState.toString();
        return this;
    }

    /**
     * <p>
     * Usage state of the function package.
     * </p>
     * 
     * @param usageState
     *        Usage state of the function package.
     * @see UsageState
     */

    public void setUsageState(String usageState) {
        this.usageState = usageState;
    }

    /**
     * <p>
     * Usage state of the function package.
     * </p>
     * 
     * @return Usage state of the function package.
     * @see UsageState
     */

    public String getUsageState() {
        return this.usageState;
    }

    /**
     * <p>
     * Usage state of the function package.
     * </p>
     * 
     * @param usageState
     *        Usage state of the function package.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see UsageState
     */

    public ListSolFunctionPackageInfo withUsageState(String usageState) {
        setUsageState(usageState);
        return this;
    }

    /**
     * <p>
     * Usage state of the function package.
     * </p>
     * 
     * @param usageState
     *        Usage state of the function package.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see UsageState
     */

    public ListSolFunctionPackageInfo withUsageState(UsageState usageState) {
        this.usageState = usageState.toString();
        return this;
    }

    /**
     * <p>
     * The product name for the network function.
     * </p>
     * 
     * @param vnfProductName
     *        The product name for the network function.
     */

    public void setVnfProductName(String vnfProductName) {
        this.vnfProductName = vnfProductName;
    }

    /**
     * <p>
     * The product name for the network function.
     * </p>
     * 
     * @return The product name for the network function.
     */

    public String getVnfProductName() {
        return this.vnfProductName;
    }

    /**
     * <p>
     * The product name for the network function.
     * </p>
     * 
     * @param vnfProductName
     *        The product name for the network function.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSolFunctionPackageInfo withVnfProductName(String vnfProductName) {
        setVnfProductName(vnfProductName);
        return this;
    }

    /**
     * <p>
     * Provider of the function package and the function package descriptor.
     * </p>
     * 
     * @param vnfProvider
     *        Provider of the function package and the function package descriptor.
     */

    public void setVnfProvider(String vnfProvider) {
        this.vnfProvider = vnfProvider;
    }

    /**
     * <p>
     * Provider of the function package and the function package descriptor.
     * </p>
     * 
     * @return Provider of the function package and the function package descriptor.
     */

    public String getVnfProvider() {
        return this.vnfProvider;
    }

    /**
     * <p>
     * Provider of the function package and the function package descriptor.
     * </p>
     * 
     * @param vnfProvider
     *        Provider of the function package and the function package descriptor.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSolFunctionPackageInfo withVnfProvider(String vnfProvider) {
        setVnfProvider(vnfProvider);
        return this;
    }

    /**
     * <p>
     * Identifies the function package and the function package descriptor.
     * </p>
     * 
     * @param vnfdId
     *        Identifies the function package and the function package descriptor.
     */

    public void setVnfdId(String vnfdId) {
        this.vnfdId = vnfdId;
    }

    /**
     * <p>
     * Identifies the function package and the function package descriptor.
     * </p>
     * 
     * @return Identifies the function package and the function package descriptor.
     */

    public String getVnfdId() {
        return this.vnfdId;
    }

    /**
     * <p>
     * Identifies the function package and the function package descriptor.
     * </p>
     * 
     * @param vnfdId
     *        Identifies the function package and the function package descriptor.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSolFunctionPackageInfo withVnfdId(String vnfdId) {
        setVnfdId(vnfdId);
        return this;
    }

    /**
     * <p>
     * Identifies the version of the function package descriptor.
     * </p>
     * 
     * @param vnfdVersion
     *        Identifies the version of the function package descriptor.
     */

    public void setVnfdVersion(String vnfdVersion) {
        this.vnfdVersion = vnfdVersion;
    }

    /**
     * <p>
     * Identifies the version of the function package descriptor.
     * </p>
     * 
     * @return Identifies the version of the function package descriptor.
     */

    public String getVnfdVersion() {
        return this.vnfdVersion;
    }

    /**
     * <p>
     * Identifies the version of the function package descriptor.
     * </p>
     * 
     * @param vnfdVersion
     *        Identifies the version of the function package descriptor.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSolFunctionPackageInfo withVnfdVersion(String vnfdVersion) {
        setVnfdVersion(vnfdVersion);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getMetadata() != null)
            sb.append("Metadata: ").append(getMetadata()).append(",");
        if (getOnboardingState() != null)
            sb.append("OnboardingState: ").append(getOnboardingState()).append(",");
        if (getOperationalState() != null)
            sb.append("OperationalState: ").append(getOperationalState()).append(",");
        if (getUsageState() != null)
            sb.append("UsageState: ").append(getUsageState()).append(",");
        if (getVnfProductName() != null)
            sb.append("VnfProductName: ").append(getVnfProductName()).append(",");
        if (getVnfProvider() != null)
            sb.append("VnfProvider: ").append(getVnfProvider()).append(",");
        if (getVnfdId() != null)
            sb.append("VnfdId: ").append(getVnfdId()).append(",");
        if (getVnfdVersion() != null)
            sb.append("VnfdVersion: ").append(getVnfdVersion());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListSolFunctionPackageInfo == false)
            return false;
        ListSolFunctionPackageInfo other = (ListSolFunctionPackageInfo) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getMetadata() == null ^ this.getMetadata() == null)
            return false;
        if (other.getMetadata() != null && other.getMetadata().equals(this.getMetadata()) == false)
            return false;
        if (other.getOnboardingState() == null ^ this.getOnboardingState() == null)
            return false;
        if (other.getOnboardingState() != null && other.getOnboardingState().equals(this.getOnboardingState()) == false)
            return false;
        if (other.getOperationalState() == null ^ this.getOperationalState() == null)
            return false;
        if (other.getOperationalState() != null && other.getOperationalState().equals(this.getOperationalState()) == false)
            return false;
        if (other.getUsageState() == null ^ this.getUsageState() == null)
            return false;
        if (other.getUsageState() != null && other.getUsageState().equals(this.getUsageState()) == false)
            return false;
        if (other.getVnfProductName() == null ^ this.getVnfProductName() == null)
            return false;
        if (other.getVnfProductName() != null && other.getVnfProductName().equals(this.getVnfProductName()) == false)
            return false;
        if (other.getVnfProvider() == null ^ this.getVnfProvider() == null)
            return false;
        if (other.getVnfProvider() != null && other.getVnfProvider().equals(this.getVnfProvider()) == false)
            return false;
        if (other.getVnfdId() == null ^ this.getVnfdId() == null)
            return false;
        if (other.getVnfdId() != null && other.getVnfdId().equals(this.getVnfdId()) == false)
            return false;
        if (other.getVnfdVersion() == null ^ this.getVnfdVersion() == null)
            return false;
        if (other.getVnfdVersion() != null && other.getVnfdVersion().equals(this.getVnfdVersion()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getMetadata() == null) ? 0 : getMetadata().hashCode());
        hashCode = prime * hashCode + ((getOnboardingState() == null) ? 0 : getOnboardingState().hashCode());
        hashCode = prime * hashCode + ((getOperationalState() == null) ? 0 : getOperationalState().hashCode());
        hashCode = prime * hashCode + ((getUsageState() == null) ? 0 : getUsageState().hashCode());
        hashCode = prime * hashCode + ((getVnfProductName() == null) ? 0 : getVnfProductName().hashCode());
        hashCode = prime * hashCode + ((getVnfProvider() == null) ? 0 : getVnfProvider().hashCode());
        hashCode = prime * hashCode + ((getVnfdId() == null) ? 0 : getVnfdId().hashCode());
        hashCode = prime * hashCode + ((getVnfdVersion() == null) ? 0 : getVnfdVersion().hashCode());
        return hashCode;
    }

    @Override
    public ListSolFunctionPackageInfo clone() {
        try {
            return (ListSolFunctionPackageInfo) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.tnb.model.transform.ListSolFunctionPackageInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
