/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite;

import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.endpointdiscovery.DefaultEndpointDiscoveryProviderChain;
import com.amazonaws.endpointdiscovery.EndpointDiscoveryProviderChain;
import com.amazonaws.internal.config.InternalConfig;
import com.amazonaws.services.timestreamwrite.AmazonTimestreamWriteAsync;
import com.amazonaws.services.timestreamwrite.AmazonTimestreamWriteAsyncClient;

@NotThreadSafe
public final class AmazonTimestreamWriteAsyncClientBuilder
extends AwsAsyncClientBuilder<AmazonTimestreamWriteAsyncClientBuilder, AmazonTimestreamWriteAsync> {
    private static final ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new ClientConfigurationFactory();
    private static final EndpointDiscoveryProviderChain DEFAULT_ENDPOINT_DISCOVERY_PROVIDER = new DefaultEndpointDiscoveryProviderChain();
    private boolean endpointDiscoveryEnabled = true;
    private boolean endpointDiscoveryDisabled = false;

    public static AmazonTimestreamWriteAsyncClientBuilder standard() {
        return new AmazonTimestreamWriteAsyncClientBuilder();
    }

    public static AmazonTimestreamWriteAsync defaultClient() {
        return (AmazonTimestreamWriteAsync)AmazonTimestreamWriteAsyncClientBuilder.standard().build();
    }

    private AmazonTimestreamWriteAsyncClientBuilder() {
        super(CLIENT_CONFIG_FACTORY);
    }

    public AmazonTimestreamWriteAsyncClientBuilder enableEndpointDiscovery() {
        this.endpointDiscoveryEnabled = true;
        return this;
    }

    public AmazonTimestreamWriteAsyncClientBuilder disableEndpointDiscovery() {
        this.endpointDiscoveryDisabled = true;
        return this;
    }

    private boolean endpointDiscoveryEnabled() {
        Boolean endpointDiscoveryChainSetting = DEFAULT_ENDPOINT_DISCOVERY_PROVIDER.endpointDiscoveryEnabled();
        if (this.endpointDiscoveryDisabled) {
            return false;
        }
        if (this.endpointDiscoveryEnabled) {
            return true;
        }
        if (endpointDiscoveryChainSetting != null && !endpointDiscoveryChainSetting.booleanValue()) {
            return false;
        }
        if (endpointDiscoveryChainSetting != null && endpointDiscoveryChainSetting.booleanValue()) {
            return true;
        }
        return InternalConfig.Factory.getInternalConfig().endpointDiscoveryEnabled();
    }

    protected AmazonTimestreamWriteAsync build(AwsAsyncClientParams params) {
        if (this.endpointDiscoveryEnabled() && this.getEndpoint() == null) {
            return new AmazonTimestreamWriteAsyncClient(params, true);
        }
        return new AmazonTimestreamWriteAsyncClient(params);
    }
}

