/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.services.textract.model.Document;
import com.amazonaws.services.textract.model.transform.S3ObjectJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class DocumentJsonUnmarshaller
implements Unmarshaller<Document, JsonUnmarshallerContext> {
    private static DocumentJsonUnmarshaller instance;

    public Document unmarshall(JsonUnmarshallerContext context) throws Exception {
        Document document = new Document();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Bytes", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    document.setBytes((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("S3Object", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    document.setS3Object(S3ObjectJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return document;
    }

    public static DocumentJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DocumentJsonUnmarshaller();
        }
        return instance;
    }
}

