/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.textract.model.DocumentMetadata;
import com.amazonaws.services.textract.model.IdentityDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnalyzeIDResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<IdentityDocument> identityDocuments;
    private DocumentMetadata documentMetadata;
    private String analyzeIDModelVersion;

    public List<IdentityDocument> getIdentityDocuments() {
        return this.identityDocuments;
    }

    public void setIdentityDocuments(Collection<IdentityDocument> identityDocuments) {
        if (identityDocuments == null) {
            this.identityDocuments = null;
            return;
        }
        this.identityDocuments = new ArrayList<IdentityDocument>(identityDocuments);
    }

    public AnalyzeIDResult withIdentityDocuments(IdentityDocument ... identityDocuments) {
        if (this.identityDocuments == null) {
            this.setIdentityDocuments(new ArrayList<IdentityDocument>(identityDocuments.length));
        }
        for (IdentityDocument ele : identityDocuments) {
            this.identityDocuments.add(ele);
        }
        return this;
    }

    public AnalyzeIDResult withIdentityDocuments(Collection<IdentityDocument> identityDocuments) {
        this.setIdentityDocuments(identityDocuments);
        return this;
    }

    public void setDocumentMetadata(DocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    public DocumentMetadata getDocumentMetadata() {
        return this.documentMetadata;
    }

    public AnalyzeIDResult withDocumentMetadata(DocumentMetadata documentMetadata) {
        this.setDocumentMetadata(documentMetadata);
        return this;
    }

    public void setAnalyzeIDModelVersion(String analyzeIDModelVersion) {
        this.analyzeIDModelVersion = analyzeIDModelVersion;
    }

    public String getAnalyzeIDModelVersion() {
        return this.analyzeIDModelVersion;
    }

    public AnalyzeIDResult withAnalyzeIDModelVersion(String analyzeIDModelVersion) {
        this.setAnalyzeIDModelVersion(analyzeIDModelVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityDocuments() != null) {
            sb.append("IdentityDocuments: ").append(this.getIdentityDocuments()).append(",");
        }
        if (this.getDocumentMetadata() != null) {
            sb.append("DocumentMetadata: ").append(this.getDocumentMetadata()).append(",");
        }
        if (this.getAnalyzeIDModelVersion() != null) {
            sb.append("AnalyzeIDModelVersion: ").append(this.getAnalyzeIDModelVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeIDResult)) {
            return false;
        }
        AnalyzeIDResult other = (AnalyzeIDResult)obj;
        if (other.getIdentityDocuments() == null ^ this.getIdentityDocuments() == null) {
            return false;
        }
        if (other.getIdentityDocuments() != null && !other.getIdentityDocuments().equals(this.getIdentityDocuments())) {
            return false;
        }
        if (other.getDocumentMetadata() == null ^ this.getDocumentMetadata() == null) {
            return false;
        }
        if (other.getDocumentMetadata() != null && !other.getDocumentMetadata().equals(this.getDocumentMetadata())) {
            return false;
        }
        if (other.getAnalyzeIDModelVersion() == null ^ this.getAnalyzeIDModelVersion() == null) {
            return false;
        }
        return other.getAnalyzeIDModelVersion() == null || other.getAnalyzeIDModelVersion().equals(this.getAnalyzeIDModelVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityDocuments() == null ? 0 : this.getIdentityDocuments().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentMetadata() == null ? 0 : this.getDocumentMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getAnalyzeIDModelVersion() == null ? 0 : this.getAnalyzeIDModelVersion().hashCode());
        return hashCode;
    }

    public AnalyzeIDResult clone() {
        try {
            return (AnalyzeIDResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

