/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.test;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.test.retry.RetryRule;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.junit.BeforeClass;
import org.junit.Rule;

public abstract class AWSIntegrationTestBase {
    private static AWSCredentials credentials;
    private static final String propertiesFilePath;
    private static final String TEST_CREDENTIALS_PROFILE_NAME = "aws-java-sdk-test";
    private static final String TOD_CREDENTIAL_PATH;
    private static final AWSCredentialsProviderChain chain;
    @Rule
    public RetryRule retry = new RetryRule(3, 2L, TimeUnit.SECONDS);

    @BeforeClass
    public static void setUpCredentials() {
        if (credentials == null) {
            try {
                credentials = chain.getCredentials();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setRetryRule(RetryRule retry) {
        this.retry = retry;
    }

    protected static AWSCredentials getCredentials() {
        return credentials;
    }

    protected String getResourceAsString(String location) {
        try {
            InputStream resourceStream = this.getClass().getResourceAsStream(location);
            String resourceAsString = IOUtils.toString((InputStream)resourceStream);
            resourceStream.close();
            return resourceAsString;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static AWSCredentialsProviderChain createChain() {
        if (StringUtils.isNullOrEmpty((String)TOD_CREDENTIAL_PATH)) {
            return new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new PropertiesFileCredentialsProvider(propertiesFilePath), new ProfileCredentialsProvider(TEST_CREDENTIALS_PROFILE_NAME), new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider()});
        }
        return new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new ProfileCredentialsProvider(TOD_CREDENTIAL_PATH, "default"), new PropertiesFileCredentialsProvider(propertiesFilePath), new ProfileCredentialsProvider(TEST_CREDENTIALS_PROFILE_NAME), new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider()});
    }

    static {
        propertiesFilePath = System.getProperty("user.home") + "/.aws/awsTestAccount.properties";
        TOD_CREDENTIAL_PATH = System.getenv("TOD_CUSTOMER_CREDENTIAL_PATH");
        chain = AWSIntegrationTestBase.createChain();
    }
}

