/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.test;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.test.retry.RetryRule;
import com.amazonaws.test.util.InputStreamUtils;
import com.amazonaws.test.util.SdkAsserts;
import com.amazonaws.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;

public abstract class AWSTestBase {
    @Deprecated
    public static AWSCredentials credentials;
    private static final String propertiesFilePath;
    private static final String TEST_CREDENTIALS_PROFILE_NAME = "aws-java-sdk-test";
    private static final AWSCredentialsProviderChain chain;
    @Rule
    public RetryRule retry = new RetryRule(3, 2L, TimeUnit.SECONDS);

    @Deprecated
    public static void setUpCredentials() {
        if (credentials == null) {
            try {
                credentials = chain.getCredentials();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void setRetryRule(RetryRule rule) {
        this.retry = rule;
    }

    protected String getResourceAsString(String location) {
        try {
            InputStream resourceStream = this.getClass().getResourceAsStream(location);
            String resourceAsString = IOUtils.toString((InputStream)resourceStream);
            resourceStream.close();
            return resourceAsString;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    protected void assertNotEmpty(String str) {
        SdkAsserts.assertNotEmpty(str);
    }

    @Deprecated
    protected void assertFileEqualsStream(File expected, InputStream actual) {
        SdkAsserts.assertFileEqualsStream(expected, actual);
    }

    @Deprecated
    protected void assertFileEqualsStream(String errmsg, File expected, InputStream actual) {
        SdkAsserts.assertFileEqualsStream(errmsg, expected, actual);
    }

    @Deprecated
    protected void assertStreamEqualsStream(InputStream expected, InputStream actual) {
        SdkAsserts.assertStreamEqualsStream(expected, actual);
    }

    @Deprecated
    protected void assertStreamEqualsStream(String errmsg, InputStream expectedInputStream, InputStream inputStream) {
        this.assertStreamEqualsStream(errmsg, expectedInputStream, inputStream);
    }

    @Deprecated
    protected void assertFileEqualsFile(File expected, File actual) {
        SdkAsserts.assertFileEqualsFile(expected, actual);
    }

    @Deprecated
    protected void assertStringEqualsStream(String expected, InputStream actual) {
        SdkAsserts.assertStringEqualsStream(expected, actual);
    }

    @Deprecated
    protected boolean doesStreamEqualStream(InputStream expected, InputStream actual) throws IOException {
        return SdkAsserts.doesStreamEqualStream(expected, actual);
    }

    @Deprecated
    protected byte[] drainInputStream(InputStream inputStream) {
        return InputStreamUtils.drainInputStream(inputStream);
    }

    @Deprecated
    protected boolean doesFileEqualStream(File expectedFile, InputStream inputStream) throws IOException {
        return SdkAsserts.doesFileEqualStream(expectedFile, inputStream);
    }

    @Deprecated
    protected void assertValidException(AmazonServiceException e) {
        SdkAsserts.assertValidException(e);
    }

    static {
        propertiesFilePath = System.getProperty("user.home") + "/.aws/awsTestAccount.properties";
        chain = new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new PropertiesFileCredentialsProvider(propertiesFilePath), new ProfileCredentialsProvider(TEST_CREDENTIALS_PROFILE_NAME), new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider()});
    }
}

