/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.test.util.hamcrest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class CollectionContainsOnly<T>
extends TypeSafeMatcher<Collection<T>> {
    private final List<Matcher<? super T>> matchers;

    private CollectionContainsOnly(List<Matcher<? super T>> matchers) {
        this.matchers = matchers;
    }

    protected boolean matchesSafely(Collection<T> actualItems) {
        ArrayList<Matcher<T>> copyOfExpected = new ArrayList<Matcher<T>>(this.matchers);
        for (T item : actualItems) {
            boolean match = false;
            for (Matcher matcher : copyOfExpected) {
                if (!matcher.matches(item)) continue;
                copyOfExpected.remove(matcher);
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return copyOfExpected.isEmpty();
    }

    public void describeTo(Description description) {
        description.appendText("collection containing ").appendList("[", ", ", "]", this.matchers);
    }

    static <T> TypeSafeMatcher<Collection<T>> containsOnly(List<Matcher<? super T>> matchers) {
        return new CollectionContainsOnly<T>(matchers);
    }
}

