/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.taxsettings.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.taxsettings.model.AdditionalInfoResponse;
import com.amazonaws.services.taxsettings.model.Address;
import com.amazonaws.services.taxsettings.model.Sector;
import com.amazonaws.services.taxsettings.model.TaxDocumentMetadata;
import com.amazonaws.services.taxsettings.model.TaxRegistrationStatus;
import com.amazonaws.services.taxsettings.model.TaxRegistrationType;
import com.amazonaws.services.taxsettings.model.transform.TaxRegistrationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TaxRegistration
implements Serializable,
Cloneable,
StructuredPojo {
    private AdditionalInfoResponse additionalTaxInformation;
    private String certifiedEmailId;
    private Address legalAddress;
    private String legalName;
    private String registrationId;
    private String registrationType;
    private String sector;
    private String status;
    private List<TaxDocumentMetadata> taxDocumentMetadatas;

    public void setAdditionalTaxInformation(AdditionalInfoResponse additionalTaxInformation) {
        this.additionalTaxInformation = additionalTaxInformation;
    }

    public AdditionalInfoResponse getAdditionalTaxInformation() {
        return this.additionalTaxInformation;
    }

    public TaxRegistration withAdditionalTaxInformation(AdditionalInfoResponse additionalTaxInformation) {
        this.setAdditionalTaxInformation(additionalTaxInformation);
        return this;
    }

    public void setCertifiedEmailId(String certifiedEmailId) {
        this.certifiedEmailId = certifiedEmailId;
    }

    public String getCertifiedEmailId() {
        return this.certifiedEmailId;
    }

    public TaxRegistration withCertifiedEmailId(String certifiedEmailId) {
        this.setCertifiedEmailId(certifiedEmailId);
        return this;
    }

    public void setLegalAddress(Address legalAddress) {
        this.legalAddress = legalAddress;
    }

    public Address getLegalAddress() {
        return this.legalAddress;
    }

    public TaxRegistration withLegalAddress(Address legalAddress) {
        this.setLegalAddress(legalAddress);
        return this;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public String getLegalName() {
        return this.legalName;
    }

    public TaxRegistration withLegalName(String legalName) {
        this.setLegalName(legalName);
        return this;
    }

    public void setRegistrationId(String registrationId) {
        this.registrationId = registrationId;
    }

    public String getRegistrationId() {
        return this.registrationId;
    }

    public TaxRegistration withRegistrationId(String registrationId) {
        this.setRegistrationId(registrationId);
        return this;
    }

    public void setRegistrationType(String registrationType) {
        this.registrationType = registrationType;
    }

    public String getRegistrationType() {
        return this.registrationType;
    }

    public TaxRegistration withRegistrationType(String registrationType) {
        this.setRegistrationType(registrationType);
        return this;
    }

    public TaxRegistration withRegistrationType(TaxRegistrationType registrationType) {
        this.registrationType = registrationType.toString();
        return this;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public String getSector() {
        return this.sector;
    }

    public TaxRegistration withSector(String sector) {
        this.setSector(sector);
        return this;
    }

    public TaxRegistration withSector(Sector sector) {
        this.sector = sector.toString();
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public TaxRegistration withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public TaxRegistration withStatus(TaxRegistrationStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<TaxDocumentMetadata> getTaxDocumentMetadatas() {
        return this.taxDocumentMetadatas;
    }

    public void setTaxDocumentMetadatas(Collection<TaxDocumentMetadata> taxDocumentMetadatas) {
        if (taxDocumentMetadatas == null) {
            this.taxDocumentMetadatas = null;
            return;
        }
        this.taxDocumentMetadatas = new ArrayList<TaxDocumentMetadata>(taxDocumentMetadatas);
    }

    public TaxRegistration withTaxDocumentMetadatas(TaxDocumentMetadata ... taxDocumentMetadatas) {
        if (this.taxDocumentMetadatas == null) {
            this.setTaxDocumentMetadatas(new ArrayList<TaxDocumentMetadata>(taxDocumentMetadatas.length));
        }
        for (TaxDocumentMetadata ele : taxDocumentMetadatas) {
            this.taxDocumentMetadatas.add(ele);
        }
        return this;
    }

    public TaxRegistration withTaxDocumentMetadatas(Collection<TaxDocumentMetadata> taxDocumentMetadatas) {
        this.setTaxDocumentMetadatas(taxDocumentMetadatas);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdditionalTaxInformation() != null) {
            sb.append("AdditionalTaxInformation: ").append(this.getAdditionalTaxInformation()).append(",");
        }
        if (this.getCertifiedEmailId() != null) {
            sb.append("CertifiedEmailId: ").append(this.getCertifiedEmailId()).append(",");
        }
        if (this.getLegalAddress() != null) {
            sb.append("LegalAddress: ").append(this.getLegalAddress()).append(",");
        }
        if (this.getLegalName() != null) {
            sb.append("LegalName: ").append(this.getLegalName()).append(",");
        }
        if (this.getRegistrationId() != null) {
            sb.append("RegistrationId: ").append(this.getRegistrationId()).append(",");
        }
        if (this.getRegistrationType() != null) {
            sb.append("RegistrationType: ").append(this.getRegistrationType()).append(",");
        }
        if (this.getSector() != null) {
            sb.append("Sector: ").append(this.getSector()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTaxDocumentMetadatas() != null) {
            sb.append("TaxDocumentMetadatas: ").append(this.getTaxDocumentMetadatas());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxRegistration)) {
            return false;
        }
        TaxRegistration other = (TaxRegistration)obj;
        if (other.getAdditionalTaxInformation() == null ^ this.getAdditionalTaxInformation() == null) {
            return false;
        }
        if (other.getAdditionalTaxInformation() != null && !other.getAdditionalTaxInformation().equals(this.getAdditionalTaxInformation())) {
            return false;
        }
        if (other.getCertifiedEmailId() == null ^ this.getCertifiedEmailId() == null) {
            return false;
        }
        if (other.getCertifiedEmailId() != null && !other.getCertifiedEmailId().equals(this.getCertifiedEmailId())) {
            return false;
        }
        if (other.getLegalAddress() == null ^ this.getLegalAddress() == null) {
            return false;
        }
        if (other.getLegalAddress() != null && !other.getLegalAddress().equals(this.getLegalAddress())) {
            return false;
        }
        if (other.getLegalName() == null ^ this.getLegalName() == null) {
            return false;
        }
        if (other.getLegalName() != null && !other.getLegalName().equals(this.getLegalName())) {
            return false;
        }
        if (other.getRegistrationId() == null ^ this.getRegistrationId() == null) {
            return false;
        }
        if (other.getRegistrationId() != null && !other.getRegistrationId().equals(this.getRegistrationId())) {
            return false;
        }
        if (other.getRegistrationType() == null ^ this.getRegistrationType() == null) {
            return false;
        }
        if (other.getRegistrationType() != null && !other.getRegistrationType().equals(this.getRegistrationType())) {
            return false;
        }
        if (other.getSector() == null ^ this.getSector() == null) {
            return false;
        }
        if (other.getSector() != null && !other.getSector().equals(this.getSector())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTaxDocumentMetadatas() == null ^ this.getTaxDocumentMetadatas() == null) {
            return false;
        }
        return other.getTaxDocumentMetadatas() == null || other.getTaxDocumentMetadatas().equals(this.getTaxDocumentMetadatas());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdditionalTaxInformation() == null ? 0 : this.getAdditionalTaxInformation().hashCode());
        hashCode = 31 * hashCode + (this.getCertifiedEmailId() == null ? 0 : this.getCertifiedEmailId().hashCode());
        hashCode = 31 * hashCode + (this.getLegalAddress() == null ? 0 : this.getLegalAddress().hashCode());
        hashCode = 31 * hashCode + (this.getLegalName() == null ? 0 : this.getLegalName().hashCode());
        hashCode = 31 * hashCode + (this.getRegistrationId() == null ? 0 : this.getRegistrationId().hashCode());
        hashCode = 31 * hashCode + (this.getRegistrationType() == null ? 0 : this.getRegistrationType().hashCode());
        hashCode = 31 * hashCode + (this.getSector() == null ? 0 : this.getSector().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTaxDocumentMetadatas() == null ? 0 : this.getTaxDocumentMetadatas().hashCode());
        return hashCode;
    }

    public TaxRegistration clone() {
        try {
            return (TaxRegistration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaxRegistrationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

