/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.synthetics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.synthetics.model.EncryptionMode;
import com.amazonaws.services.synthetics.model.transform.S3EncryptionConfigMarshaller;
import java.io.Serializable;

public class S3EncryptionConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String encryptionMode;
    private String kmsKeyArn;

    public void setEncryptionMode(String encryptionMode) {
        this.encryptionMode = encryptionMode;
    }

    public String getEncryptionMode() {
        return this.encryptionMode;
    }

    public S3EncryptionConfig withEncryptionMode(String encryptionMode) {
        this.setEncryptionMode(encryptionMode);
        return this;
    }

    public S3EncryptionConfig withEncryptionMode(EncryptionMode encryptionMode) {
        this.encryptionMode = encryptionMode.toString();
        return this;
    }

    public void setKmsKeyArn(String kmsKeyArn) {
        this.kmsKeyArn = kmsKeyArn;
    }

    public String getKmsKeyArn() {
        return this.kmsKeyArn;
    }

    public S3EncryptionConfig withKmsKeyArn(String kmsKeyArn) {
        this.setKmsKeyArn(kmsKeyArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionMode() != null) {
            sb.append("EncryptionMode: ").append(this.getEncryptionMode()).append(",");
        }
        if (this.getKmsKeyArn() != null) {
            sb.append("KmsKeyArn: ").append(this.getKmsKeyArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3EncryptionConfig)) {
            return false;
        }
        S3EncryptionConfig other = (S3EncryptionConfig)obj;
        if (other.getEncryptionMode() == null ^ this.getEncryptionMode() == null) {
            return false;
        }
        if (other.getEncryptionMode() != null && !other.getEncryptionMode().equals(this.getEncryptionMode())) {
            return false;
        }
        if (other.getKmsKeyArn() == null ^ this.getKmsKeyArn() == null) {
            return false;
        }
        return other.getKmsKeyArn() == null || other.getKmsKeyArn().equals(this.getKmsKeyArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionMode() == null ? 0 : this.getEncryptionMode().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyArn() == null ? 0 : this.getKmsKeyArn().hashCode());
        return hashCode;
    }

    public S3EncryptionConfig clone() {
        try {
            return (S3EncryptionConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3EncryptionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

