/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.WorkflowContext;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.generic.ContinueAsNewWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.flow.worker.ComponentVersions;
import java.util.List;
import software.amazon.awssdk.services.swf.model.ChildPolicy;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes;

class WorkflowContextImpl
implements WorkflowContext {
    private final WorkflowClock clock;
    private final PollForDecisionTaskResponse decisionTask;
    private boolean cancelRequested;
    private ContinueAsNewWorkflowExecutionParameters continueAsNewOnCompletion;
    private ComponentVersions componentVersions;
    private WorkflowExecutionStartedEventAttributes workflowStartedEventAttributes;

    public WorkflowContextImpl(PollForDecisionTaskResponse decisionTask, WorkflowClock clock) {
        this.decisionTask = decisionTask;
        this.clock = clock;
        HistoryEvent firstHistoryEvent = (HistoryEvent)decisionTask.events().get(0);
        this.workflowStartedEventAttributes = firstHistoryEvent.workflowExecutionStartedEventAttributes();
    }

    @Override
    public WorkflowExecution getWorkflowExecution() {
        return WorkflowExecution.fromSdkType(this.decisionTask.workflowExecution());
    }

    @Override
    public WorkflowType getWorkflowType() {
        return WorkflowType.fromSdkType(this.decisionTask.workflowType());
    }

    @Override
    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    void setCancelRequested(boolean flag) {
        this.cancelRequested = flag;
    }

    @Override
    public ContinueAsNewWorkflowExecutionParameters getContinueAsNewOnCompletion() {
        return this.continueAsNewOnCompletion;
    }

    @Override
    public void setContinueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters continueParameters) {
        this.continueAsNewOnCompletion = continueParameters;
    }

    @Override
    public WorkflowExecution getParentWorkflowExecution() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return WorkflowExecution.fromSdkType(attributes.parentWorkflowExecution());
    }

    @Override
    public List<String> getTagList() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.tagList();
    }

    @Override
    public ChildPolicy getChildPolicy() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return ChildPolicy.fromValue((String)attributes.childPolicyAsString());
    }

    @Override
    public String getContinuedExecutionRunId() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.continuedExecutionRunId();
    }

    @Override
    public long getExecutionStartToCloseTimeout() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        String result = attributes.executionStartToCloseTimeout();
        return FlowHelpers.durationToSeconds(result);
    }

    @Override
    public String getTaskList() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.taskList().name();
    }

    @Override
    public String getLambdaRole() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        return attributes.lambdaRole();
    }

    private WorkflowExecutionStartedEventAttributes getWorkflowStartedEventAttributes() {
        return this.workflowStartedEventAttributes;
    }

    @Override
    public int getTaskPriority() {
        WorkflowExecutionStartedEventAttributes attributes = this.getWorkflowStartedEventAttributes();
        String result = attributes.taskPriority();
        return FlowHelpers.taskPriorityToInt(result);
    }

    @Override
    public boolean isImplementationVersion(String component, int version) {
        return this.componentVersions.isVersion(component, version, this.clock.isReplaying());
    }

    @Override
    public Integer getVersion(String component) {
        return this.componentVersions.getCurrentVersion(component);
    }

    void setComponentVersions(ComponentVersions componentVersions) {
        this.componentVersions = componentVersions;
    }
}

