/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.StartTimerFailedException;
import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTask;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCancellationHandler;
import com.amazonaws.services.simpleworkflow.flow.core.ExternalTaskCompletionHandle;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.OpenRequestInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.StartTimerDecisionAttributes;
import software.amazon.awssdk.services.swf.model.StartTimerFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.TimerCanceledEventAttributes;
import software.amazon.awssdk.services.swf.model.TimerFiredEventAttributes;

class WorkflowClockImpl
implements WorkflowClock {
    private static final Log log = LogFactory.getLog(WorkflowClockImpl.class);
    private final DecisionsHelper decisions;
    private final Map<String, OpenRequestInfo<?, ?>> scheduledTimers = new HashMap();
    private long replayCurrentTimeMilliseconds;
    private boolean replaying = true;

    WorkflowClockImpl(DecisionsHelper decisions) {
        this.decisions = decisions;
    }

    @Override
    public long currentTimeMillis() {
        return this.replayCurrentTimeMilliseconds;
    }

    void setReplayCurrentTimeMilliseconds(long replayCurrentTimeMilliseconds) {
        this.replayCurrentTimeMilliseconds = replayCurrentTimeMilliseconds;
    }

    @Override
    public boolean isReplaying() {
        return this.replaying;
    }

    void setReplaying(boolean replaying) {
        this.replaying = replaying;
    }

    @Override
    public Promise<Void> createTimer(long delaySeconds) {
        return this.createTimer(delaySeconds, null);
    }

    @Override
    public <T> Promise<T> createTimer(long delaySeconds, T userContext) {
        String timerId = this.decisions.getNextId();
        return this.createTimer(delaySeconds, userContext, timerId);
    }

    @Override
    public <T> Promise<T> createTimer(long delaySeconds, final T userContext, final String timerId) {
        if (delaySeconds < 0L) {
            throw new IllegalArgumentException("Negative delaySeconds: " + delaySeconds);
        }
        if (delaySeconds == 0L) {
            return Promise.asPromise(userContext);
        }
        final OpenRequestInfo context = new OpenRequestInfo(userContext);
        final StartTimerDecisionAttributes timer = (StartTimerDecisionAttributes)StartTimerDecisionAttributes.builder().startToFireTimeout(FlowHelpers.secondsToDuration(delaySeconds)).timerId(timerId).build();
        String taskName = "timerId=" + timer.timerId() + ", delaySeconds=" + timer.startToFireTimeout();
        new ExternalTask(new Promise[0]){

            @Override
            protected ExternalTaskCancellationHandler doExecute(ExternalTaskCompletionHandle handle) throws Throwable {
                WorkflowClockImpl.this.decisions.startTimer(timer, userContext);
                context.setCompletionHandle(handle);
                WorkflowClockImpl.this.scheduledTimers.put(timerId, context);
                return new TimerCancellationHandler(timerId);
            }
        }.setName(taskName);
        context.setResultDescription("createTimer " + taskName);
        return context.getResult();
    }

    void handleTimerFired(Long eventId, TimerFiredEventAttributes attributes) {
        String timerId = attributes.timerId();
        if (this.decisions.handleTimerClosed(timerId)) {
            OpenRequestInfo<?, ?> scheduled = this.scheduledTimers.remove(timerId);
            if (scheduled != null) {
                ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
                scheduled.getResult().set(scheduled.getUserContext());
                completionHandle.complete();
            }
        } else {
            log.debug((Object)"handleTimerFired not complete");
        }
    }

    void handleStartTimerFailed(HistoryEvent event) {
        StartTimerFailedEventAttributes attributes = event.startTimerFailedEventAttributes();
        String timerId = attributes.timerId();
        if (this.decisions.handleStartTimerFailed(event)) {
            OpenRequestInfo<?, ?> scheduled = this.scheduledTimers.remove(timerId);
            if (scheduled != null) {
                ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
                Object createTimerUserContext = scheduled.getUserContext();
                String cause = attributes.causeAsString();
                StartTimerFailedException failure = new StartTimerFailedException(event.eventId(), timerId, createTimerUserContext, cause);
                completionHandle.fail(failure);
            }
        } else {
            log.debug((Object)"handleStartTimerFailed not complete");
        }
    }

    void handleTimerCanceled(HistoryEvent event) {
        TimerCanceledEventAttributes attributes = event.timerCanceledEventAttributes();
        String timerId = attributes.timerId();
        if (this.decisions.handleTimerCanceled(event)) {
            OpenRequestInfo<?, ?> scheduled = this.scheduledTimers.remove(timerId);
            if (scheduled != null) {
                ExternalTaskCompletionHandle completionHandle = scheduled.getCompletionHandle();
                CancellationException exception = new CancellationException();
                completionHandle.fail(exception);
            }
        } else {
            log.debug((Object)"handleTimerCanceled not complete");
        }
    }

    private final class TimerCancellationHandler
    implements ExternalTaskCancellationHandler {
        private final String timerId;

        private TimerCancellationHandler(String timerId) {
            this.timerId = timerId;
        }

        @Override
        public void handleCancellation(Throwable cause) {
            WorkflowClockImpl.this.decisions.cancelTimer(this.timerId, new Runnable(){

                @Override
                public void run() {
                    OpenRequestInfo scheduled = (OpenRequestInfo)WorkflowClockImpl.this.scheduledTimers.remove(TimerCancellationHandler.this.timerId);
                    ExternalTaskCompletionHandle context = scheduled.getCompletionHandle();
                    context.complete();
                }
            });
        }
    }
}

