/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class SuspendableSemaphore {
    private final Semaphore semaphore;
    private final Lock lock = new ReentrantLock();
    private final Condition suspentionCondition = this.lock.newCondition();
    private boolean suspended;

    public SuspendableSemaphore(int permits, boolean fair) {
        this.semaphore = new Semaphore(permits, fair);
    }

    public SuspendableSemaphore(int permits) {
        this.semaphore = new Semaphore(permits);
    }

    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
        this.lock.lock();
        try {
            while (this.suspended) {
                this.suspentionCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void release() {
        this.semaphore.release();
    }

    public void suspend() {
        this.lock.lock();
        try {
            this.suspended = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void resume() {
        this.lock.lock();
        try {
            this.suspended = false;
            this.suspentionCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isSuspended() {
        this.lock.lock();
        try {
            boolean bl = this.suspended;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

