/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleWorkflowDefinitionFactoryFactory
extends WorkflowDefinitionFactoryFactory {
    private final Map<WorkflowType, WorkflowDefinitionFactory> factoriesMap = new HashMap<WorkflowType, WorkflowDefinitionFactory>();
    private final List<WorkflowType> typesToRegister = new ArrayList<WorkflowType>();

    @Override
    public WorkflowDefinitionFactory getWorkflowDefinitionFactory(WorkflowType workflowType) {
        return this.factoriesMap.get(workflowType);
    }

    @Override
    public Iterable<WorkflowType> getWorkflowTypesToRegister() {
        return this.typesToRegister;
    }

    public void setWorkflowDefinitionFactories(Collection<WorkflowDefinitionFactory> factories) {
        for (WorkflowDefinitionFactory factory : factories) {
            this.addWorkflowDefinitionFactory(factory);
        }
    }

    public Collection<WorkflowDefinitionFactory> getWorkflowDefinitionFactories() {
        return this.factoriesMap.values();
    }

    public void addWorkflowDefinitionFactory(WorkflowDefinitionFactory factory) {
        WorkflowType workflowType = factory.getWorkflowType();
        this.factoriesMap.put(workflowType, factory);
        WorkflowTypeRegistrationOptions registrationOptions = factory.getWorkflowRegistrationOptions();
        if (registrationOptions != null) {
            this.typesToRegister.add(workflowType);
        }
    }
}

