/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.IncompatibleWorkflowDefinition;

class ComponentVersion {
    private final String componentName;
    private int maximumSupportedImplementationVersion;
    private int minimumSupportedImplementationVersion;
    private int maximumAllowedImplementationVersion = Integer.MAX_VALUE;
    private int currentVersion;
    private Integer versionFromHistory;
    private Integer maxSkippedVersion;

    public ComponentVersion(String componentName) {
        this.componentName = componentName;
    }

    void setVersionFromHistory(int version) {
        if (this.versionFromHistory != null && version < this.versionFromHistory) {
            throw new IncompatibleWorkflowDefinition("Version from history cannot decrease from " + this.versionFromHistory + " to " + version + " for \"" + this.componentName + "\" component");
        }
        this.currentVersion = version;
        this.versionFromHistory = version;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public int getMaximumSupportedImplementationVersion() {
        return this.maximumSupportedImplementationVersion;
    }

    public void setMaximumSupportedImplementationVersion(int maximumSupportedImplementationVersion) {
        if (this.versionFromHistory != null && maximumSupportedImplementationVersion < this.versionFromHistory) {
            throw new IncompatibleWorkflowDefinition("Maximum supported implementation version=" + maximumSupportedImplementationVersion + " is below one found in the history " + this.versionFromHistory + " for \"" + this.componentName + "\" component.");
        }
        this.maximumSupportedImplementationVersion = maximumSupportedImplementationVersion;
    }

    public int getMinimumSupportedImplementationVersion() {
        return this.minimumSupportedImplementationVersion;
    }

    public void setMinimumSupportedImplementationVersion(int minimumSupportedImplementationVersion) {
        this.minimumSupportedImplementationVersion = minimumSupportedImplementationVersion;
        if (this.versionFromHistory != null && this.versionFromHistory < minimumSupportedImplementationVersion) {
            throw new IncompatibleWorkflowDefinition("Minimum supported implementation version=" + minimumSupportedImplementationVersion + " is larger than one found in the history " + this.versionFromHistory + " for \"" + this.componentName + "\" component.");
        }
        if (this.maximumAllowedImplementationVersion < minimumSupportedImplementationVersion) {
            throw new IncompatibleWorkflowDefinition("Minimum supported implementation version=" + minimumSupportedImplementationVersion + " is larger than maximumAllowedImplementationVersion=" + this.maximumAllowedImplementationVersion + " for \"" + this.componentName + "\" component.");
        }
        if (minimumSupportedImplementationVersion > this.currentVersion) {
            this.currentVersion = minimumSupportedImplementationVersion;
        }
    }

    public int getMaximumAllowedImplementationVersion() {
        return this.maximumAllowedImplementationVersion;
    }

    public void setMaximumAllowedImplementationVersion(int maximumAllowedImplementationVersion) {
        this.maximumAllowedImplementationVersion = maximumAllowedImplementationVersion;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public boolean isVersion(int version, boolean replaying) {
        if (this.maximumSupportedImplementationVersion < version) {
            throw new IncompatibleWorkflowDefinition("version=" + version + " is larger than maximumSupportedImplementationVersion=" + this.maximumSupportedImplementationVersion + " for \"" + this.componentName + "\" component.");
        }
        if (this.minimumSupportedImplementationVersion > version) {
            throw new IncompatibleWorkflowDefinition("version=" + version + " is smaller than minimumSupportedImplementationVersion=" + this.minimumSupportedImplementationVersion + " for \"" + this.componentName + "\" component.");
        }
        if (this.maxSkippedVersion != null && this.maxSkippedVersion <= version) {
            return false;
        }
        if (this.currentVersion >= version) {
            return true;
        }
        if (replaying) {
            if (version == this.minimumSupportedImplementationVersion) {
                this.currentVersion = version;
                return true;
            }
            if (this.maxSkippedVersion == null || this.maxSkippedVersion < version) {
                this.maxSkippedVersion = version;
            }
            return false;
        }
        if (this.maximumAllowedImplementationVersion < version) {
            return false;
        }
        this.currentVersion = version;
        return true;
    }
}

