/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.ChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.DefaultChildWorkflowIdHandler;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncTaskInfo;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowTypeComponentImplementationVersion;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowTypeImplementationOptions;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.amazonaws.services.simpleworkflow.flow.worker.AffinityHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecider;
import com.amazonaws.services.simpleworkflow.flow.worker.ComponentVersions;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionTaskHandler;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.HandleDecisionTaskResults;
import com.amazonaws.services.simpleworkflow.flow.worker.HistoryHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.IncompatibleWorkflowDefinition;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.services.swf.model.Decision;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;
import software.amazon.awssdk.services.swf.model.RespondDecisionTaskCompletedRequest;

public class AsyncDecisionTaskHandler
extends DecisionTaskHandler {
    static final String COMPONENT_VERSION_MARKER = "*component_version*";
    static final String COMPONENT_VERSION_RECORD_SEPARATOR = "\n";
    static final String COMPONENT_VERSION_SEPARATOR = "\t";
    static final String COMPONENT_VERSION_SEPARATORS_PATTERN = "\n|\t";
    private static final Log log = LogFactory.getLog(AsyncDecisionTaskHandler.class);
    private static final Log asyncThreadDumpLog = LogFactory.getLog((String)(AsyncDecisionTaskHandler.class.getName() + ".waitingTasksStacks"));
    private final WorkflowDefinitionFactoryFactory definitionFactoryFactory;
    private final ChildWorkflowIdHandler childWorkflowIdHandler;
    private final boolean skipFailedCheck;
    private SimpleWorkflowClientConfig clientConfig = SimpleWorkflowClientConfig.ofDefaults();
    private AffinityHelper affinityHelper;

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory) {
        this(definitionFactoryFactory, false);
    }

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory, ChildWorkflowIdHandler childWorkflowIdHandler) {
        this(definitionFactoryFactory, false, childWorkflowIdHandler);
    }

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory, ChildWorkflowIdHandler childWorkflowIdHandler, SimpleWorkflowClientConfig config) {
        this(definitionFactoryFactory, childWorkflowIdHandler);
        this.clientConfig = config;
    }

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory, ChildWorkflowIdHandler childWorkflowIdHandler, AffinityHelper affinityHelper, SimpleWorkflowClientConfig config) {
        this(definitionFactoryFactory, childWorkflowIdHandler, config);
        this.affinityHelper = affinityHelper;
    }

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory, boolean skipFailedCheck) {
        this(definitionFactoryFactory, skipFailedCheck, null);
    }

    public AsyncDecisionTaskHandler(WorkflowDefinitionFactoryFactory definitionFactoryFactory, boolean skipFailedCheck, ChildWorkflowIdHandler childWorkflowIdHandler) {
        this.definitionFactoryFactory = definitionFactoryFactory;
        this.skipFailedCheck = skipFailedCheck;
        this.childWorkflowIdHandler = childWorkflowIdHandler != null ? childWorkflowIdHandler : new DefaultChildWorkflowIdHandler();
    }

    @Override
    public HandleDecisionTaskResults handleDecisionTask(Iterator<PollForDecisionTaskResponse> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        historyHelper = decider.getHistoryHelper();
        DecisionsHelper decisionsHelper = decider.getDecisionsHelper();
        List<Decision> decisions = decisionsHelper.getDecisions();
        PollForDecisionTaskResponse decisionTask = historyHelper.getDecisionTask();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WorkflowTask taskId=" + decisionTask.startedEventId() + ", taskToken=" + decisionTask.taskToken() + " completed with " + decisions.size() + " new decisions"));
        }
        if (decisions.size() == 0 && asyncThreadDumpLog.isTraceEnabled()) {
            asyncThreadDumpLog.trace((Object)("Empty decision list with the following waiting tasks:\n" + decider.getAsynchronousThreadDumpAsString()));
        }
        RespondDecisionTaskCompletedRequest.Builder completedRequestBuilder = RespondDecisionTaskCompletedRequest.builder();
        completedRequestBuilder.taskToken(decisionTask.taskToken()).decisions(decisions);
        String contextData = decisionsHelper.getWorkflowContextDataToReturn();
        ComponentVersions componentVersions = historyHelper.getComponentVersions();
        Map<String, Integer> versionsToSave = componentVersions.getVersionsToSave();
        String executionContext = this.getExecutionContext(contextData, versionsToSave);
        if (historyHelper.getWorkflowContextData() == null || !historyHelper.getWorkflowContextData().equals(executionContext)) {
            completedRequestBuilder.executionContext(executionContext);
        }
        return new HandleDecisionTaskResults((RespondDecisionTaskCompletedRequest)completedRequestBuilder.build(), decider);
    }

    private String getExecutionContext(String contextData, Map<String, Integer> componentVersions) {
        int versionsSize = componentVersions.size();
        if (versionsSize == 0 && contextData == null) {
            return null;
        }
        StringBuilder executionContext = new StringBuilder();
        if (versionsSize > 0) {
            executionContext.append(COMPONENT_VERSION_MARKER);
            executionContext.append(COMPONENT_VERSION_SEPARATOR);
            executionContext.append(versionsSize);
            executionContext.append(COMPONENT_VERSION_RECORD_SEPARATOR);
            for (Map.Entry<String, Integer> version : componentVersions.entrySet()) {
                executionContext.append(version.getKey());
                executionContext.append(COMPONENT_VERSION_SEPARATOR);
                executionContext.append(version.getValue());
                executionContext.append(COMPONENT_VERSION_RECORD_SEPARATOR);
            }
        }
        executionContext.append(contextData);
        return executionContext.toString();
    }

    @Override
    public WorkflowDefinition loadWorkflowThroughReplay(Iterator<PollForDecisionTaskResponse> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        DecisionsHelper decisionsHelper = decider.getDecisionsHelper();
        if (!this.skipFailedCheck && decisionsHelper.isWorkflowFailed()) {
            throw new IllegalStateException("Cannot load failed workflow", decisionsHelper.getWorkflowFailureCause());
        }
        return decider.getWorkflowDefinition();
    }

    @Override
    public List<AsyncTaskInfo> getAsynchronousThreadDump(Iterator<PollForDecisionTaskResponse> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        return decider.getAsynchronousThreadDump();
    }

    @Override
    public String getAsynchronousThreadDumpAsString(Iterator<PollForDecisionTaskResponse> decisionTaskIterator) throws Exception {
        HistoryHelper historyHelper = new HistoryHelper(decisionTaskIterator);
        AsyncDecider decider = this.createDecider(historyHelper);
        decider.decide();
        return decider.getAsynchronousThreadDumpAsString();
    }

    private AsyncDecider createDecider(HistoryHelper historyHelper) throws Exception {
        WorkflowDefinitionFactory workflowDefinitionFactory;
        PollForDecisionTaskResponse decisionTask = historyHelper.getDecisionTask();
        WorkflowType workflowType = WorkflowType.fromSdkType(decisionTask.workflowType());
        if (log.isDebugEnabled()) {
            log.debug((Object)("WorkflowTask received: taskId=" + decisionTask.startedEventId() + ", taskToken=" + decisionTask.taskToken() + ", workflowExecution=" + decisionTask.workflowExecution()));
        }
        if ((workflowDefinitionFactory = this.definitionFactoryFactory.getWorkflowDefinitionFactory(workflowType)) == null) {
            ThreadLocalMetrics.getMetrics().recordCount(MetricName.TYPE_NOT_FOUND.getName(), 1.0, MetricName.getWorkflowTypeDimension(workflowType));
            log.error((Object)("Received decision task for workflow type not configured with a worker: workflowType=" + decisionTask.workflowType() + ", taskToken=" + decisionTask.taskToken() + ", workflowExecution=" + decisionTask.workflowExecution()));
            Iterable<WorkflowType> typesToRegister = this.definitionFactoryFactory.getWorkflowTypesToRegister();
            StringBuilder types = new StringBuilder();
            types.append("[");
            for (WorkflowType t : typesToRegister) {
                if (types.length() > 1) {
                    types.append(", ");
                }
                types.append(t);
            }
            types.append("]");
            throw new IncompatibleWorkflowDefinition("Workflow type \"" + workflowType + "\" is not supported by the WorkflowWorker. Possible cause is workflow type version change without changing task list name. Workflow types registered by the worker are: " + types.toString());
        }
        if (this.affinityHelper != null && this.affinityHelper.isAffinityWorker()) {
            AsyncDecider decider = this.affinityHelper.getDeciderForDecisionTask(decisionTask);
            if (decider != null) {
                historyHelper.setComponentVersions(decider.getHistoryHelper().getComponentVersions());
                historyHelper.setWorkflowContextData(decider.getHistoryHelper().getWorkflowContextData());
                historyHelper.getSingleDecisionEvents();
                decider.setHistoryHelper(historyHelper);
                ThreadLocalMetrics.getMetrics().recordCount(MetricName.VALID_DECIDER_FOUND_IN_CACHE.getName(), 1.0, MetricName.getWorkflowTypeDimension(WorkflowType.fromSdkType(decisionTask.workflowType())));
                return decider;
            }
            historyHelper = this.affinityHelper.createHistoryHelperForDecisionTask(decisionTask);
            ThreadLocalMetrics.getMetrics().recordCount(MetricName.VALID_DECIDER_FOUND_IN_CACHE.getName(), 0.0, MetricName.getWorkflowTypeDimension(WorkflowType.fromSdkType(decisionTask.workflowType())));
        }
        DecisionsHelper decisionsHelper = new DecisionsHelper(decisionTask, this.childWorkflowIdHandler, this.clientConfig);
        WorkflowTypeImplementationOptions workflowImplementationOptions = workflowDefinitionFactory.getWorkflowImplementationOptions();
        if (workflowImplementationOptions != null) {
            List<WorkflowTypeComponentImplementationVersion> implementationComponentVersions = workflowImplementationOptions.getImplementationComponentVersions();
            historyHelper.getComponentVersions().setWorkflowImplementationComponentVersions(implementationComponentVersions);
        }
        return new AsyncDecider(workflowDefinitionFactory, historyHelper, decisionsHelper);
    }

    @Override
    public AffinityHelper getAffinityHelper() {
        return this.affinityHelper;
    }
}

