/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.WorkflowException;
import com.amazonaws.services.simpleworkflow.flow.WorkflowExecutionLocal;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncScope;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncTaskInfo;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.generic.ContinueAsNewWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.amazonaws.services.simpleworkflow.flow.worker.CurrentDecisionContext;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionContextImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionsHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericActivityClientImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericWorkflowClientImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.HistoryHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.LambdaFunctionClientImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.WorkflowClockImpl;
import com.amazonaws.services.simpleworkflow.flow.worker.WorkflowContextImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.swf.model.EventType;
import software.amazon.awssdk.services.swf.model.HistoryEvent;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;
import software.amazon.awssdk.services.swf.model.StartTimerFailedEventAttributes;
import software.amazon.awssdk.services.swf.model.TimerFiredEventAttributes;
import software.amazon.awssdk.services.swf.model.TimerStartedEventAttributes;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionSignaledEventAttributes;
import software.amazon.awssdk.services.swf.model.WorkflowExecutionStartedEventAttributes;

public class AsyncDecider {
    private static final Log log = LogFactory.getLog(AsyncDecider.class);
    private final WorkflowDefinitionFactory workflowDefinitionFactory;
    private WorkflowDefinition definition;
    private HistoryHelper historyHelper;
    private final DecisionsHelper decisionsHelper;
    private final GenericActivityClientImpl activityClient;
    private final GenericWorkflowClientImpl workflowClient;
    private final LambdaFunctionClientImpl lambdaFunctionClient;
    private final WorkflowClockImpl workflowClock;
    private final DecisionContext context;
    private WorkflowAsyncScope workflowAsyncScope;
    private boolean cancelRequested;
    private WorkflowContextImpl workflowContext;
    private boolean unhandledDecision;
    private boolean completed;
    private Throwable failure;
    private String originalTaskList;
    private Map<String, WorkflowExecutionLocal.Wrapper> savedWorkflowExecutionLocalValues;

    public AsyncDecider(WorkflowDefinitionFactory workflowDefinitionFactory, HistoryHelper historyHelper, DecisionsHelper decisionsHelper) throws Exception {
        this.workflowDefinitionFactory = workflowDefinitionFactory;
        this.historyHelper = historyHelper;
        this.decisionsHelper = decisionsHelper;
        this.activityClient = new GenericActivityClientImpl(decisionsHelper);
        PollForDecisionTaskResponse decisionTask = historyHelper.getDecisionTask();
        this.workflowClock = new WorkflowClockImpl(decisionsHelper);
        this.workflowContext = new WorkflowContextImpl(decisionTask, this.workflowClock);
        this.workflowContext.setComponentVersions(historyHelper.getComponentVersions());
        this.workflowClient = new GenericWorkflowClientImpl(decisionsHelper, this.workflowContext);
        this.lambdaFunctionClient = new LambdaFunctionClientImpl(decisionsHelper);
        this.context = new DecisionContextImpl(this.activityClient, this.workflowClient, this.workflowClock, this.workflowContext, this.lambdaFunctionClient);
    }

    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    public boolean hasCompletedWithoutUnhandledDecision() {
        return this.completed && !this.unhandledDecision;
    }

    private void handleWorkflowExecutionStarted(HistoryEvent event) {
        this.workflowAsyncScope = new WorkflowExecuteAsyncScope(event);
        this.originalTaskList = event.workflowExecutionStartedEventAttributes().taskList().name();
    }

    private void processEvent(HistoryEvent event, EventType eventType) throws Throwable {
        switch (eventType) {
            case ACTIVITY_TASK_CANCELED: {
                this.activityClient.handleActivityTaskCanceled(event);
                break;
            }
            case ACTIVITY_TASK_COMPLETED: {
                this.activityClient.handleActivityTaskCompleted(event);
                break;
            }
            case ACTIVITY_TASK_FAILED: {
                this.activityClient.handleActivityTaskFailed(event);
                break;
            }
            case ACTIVITY_TASK_STARTED: {
                this.activityClient.handleActivityTaskStarted(event.activityTaskStartedEventAttributes());
                break;
            }
            case ACTIVITY_TASK_TIMED_OUT: {
                this.activityClient.handleActivityTaskTimedOut(event);
                break;
            }
            case EXTERNAL_WORKFLOW_EXECUTION_CANCEL_REQUESTED: {
                this.workflowClient.handleChildWorkflowExecutionCancelRequested(event);
                break;
            }
            case CHILD_WORKFLOW_EXECUTION_CANCELED: {
                this.workflowClient.handleChildWorkflowExecutionCanceled(event);
                break;
            }
            case CHILD_WORKFLOW_EXECUTION_COMPLETED: {
                this.workflowClient.handleChildWorkflowExecutionCompleted(event);
                break;
            }
            case CHILD_WORKFLOW_EXECUTION_FAILED: {
                this.workflowClient.handleChildWorkflowExecutionFailed(event);
                break;
            }
            case CHILD_WORKFLOW_EXECUTION_STARTED: {
                this.workflowClient.handleChildWorkflowExecutionStarted(event);
                break;
            }
            case CHILD_WORKFLOW_EXECUTION_TERMINATED: {
                this.workflowClient.handleChildWorkflowExecutionTerminated(event);
                break;
            }
            case CHILD_WORKFLOW_EXECUTION_TIMED_OUT: {
                this.workflowClient.handleChildWorkflowExecutionTimedOut(event);
                break;
            }
            case DECISION_TASK_COMPLETED: {
                this.handleDecisionTaskCompleted(event);
                break;
            }
            case DECISION_TASK_SCHEDULED: {
                break;
            }
            case DECISION_TASK_STARTED: {
                this.handleDecisionTaskStarted(event);
                break;
            }
            case DECISION_TASK_TIMED_OUT: {
                break;
            }
            case EXTERNAL_WORKFLOW_EXECUTION_SIGNALED: {
                this.workflowClient.handleExternalWorkflowExecutionSignaled(event);
                break;
            }
            case SCHEDULE_ACTIVITY_TASK_FAILED: {
                this.activityClient.handleScheduleActivityTaskFailed(event);
                break;
            }
            case SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_FAILED: {
                this.workflowClient.handleSignalExternalWorkflowExecutionFailed(event);
                break;
            }
            case START_CHILD_WORKFLOW_EXECUTION_FAILED: {
                this.workflowClient.handleStartChildWorkflowExecutionFailed(event);
                break;
            }
            case START_TIMER_FAILED: {
                this.handleStartTimerFailed(event);
                break;
            }
            case TIMER_FIRED: {
                this.handleTimerFired(event);
                break;
            }
            case WORKFLOW_EXECUTION_CANCEL_REQUESTED: {
                this.handleWorkflowExecutionCancelRequested(event);
                break;
            }
            case WORKFLOW_EXECUTION_SIGNALED: {
                this.handleWorkflowExecutionSignaled(event);
                break;
            }
            case WORKFLOW_EXECUTION_STARTED: {
                this.handleWorkflowExecutionStarted(event);
                break;
            }
            case WORKFLOW_EXECUTION_TERMINATED: {
                break;
            }
            case WORKFLOW_EXECUTION_TIMED_OUT: {
                break;
            }
            case ACTIVITY_TASK_SCHEDULED: {
                this.decisionsHelper.handleActivityTaskScheduled(event);
                break;
            }
            case ACTIVITY_TASK_CANCEL_REQUESTED: {
                this.decisionsHelper.handleActivityTaskCancelRequested(event);
                break;
            }
            case REQUEST_CANCEL_ACTIVITY_TASK_FAILED: {
                this.decisionsHelper.handleRequestCancelActivityTaskFailed(event);
                break;
            }
            case MARKER_RECORDED: {
                break;
            }
            case RECORD_MARKER_FAILED: {
                break;
            }
            case WORKFLOW_EXECUTION_COMPLETED: {
                break;
            }
            case COMPLETE_WORKFLOW_EXECUTION_FAILED: {
                this.unhandledDecision = true;
                this.decisionsHelper.handleCompleteWorkflowExecutionFailed(event);
                break;
            }
            case WORKFLOW_EXECUTION_FAILED: {
                break;
            }
            case FAIL_WORKFLOW_EXECUTION_FAILED: {
                this.unhandledDecision = true;
                this.decisionsHelper.handleFailWorkflowExecutionFailed(event);
                break;
            }
            case WORKFLOW_EXECUTION_CANCELED: {
                break;
            }
            case CANCEL_WORKFLOW_EXECUTION_FAILED: {
                this.unhandledDecision = true;
                this.decisionsHelper.handleCancelWorkflowExecutionFailed(event);
                break;
            }
            case WORKFLOW_EXECUTION_CONTINUED_AS_NEW: {
                break;
            }
            case CONTINUE_AS_NEW_WORKFLOW_EXECUTION_FAILED: {
                this.unhandledDecision = true;
                this.decisionsHelper.handleContinueAsNewWorkflowExecutionFailed(event);
                break;
            }
            case TIMER_STARTED: {
                this.handleTimerStarted(event);
                break;
            }
            case TIMER_CANCELED: {
                this.workflowClock.handleTimerCanceled(event);
                break;
            }
            case LAMBDA_FUNCTION_SCHEDULED: {
                this.decisionsHelper.handleLambdaFunctionScheduled(event);
                break;
            }
            case LAMBDA_FUNCTION_STARTED: {
                this.lambdaFunctionClient.handleLambdaFunctionStarted(event.lambdaFunctionStartedEventAttributes());
                break;
            }
            case LAMBDA_FUNCTION_COMPLETED: {
                this.lambdaFunctionClient.handleLambdaFunctionCompleted(event);
                break;
            }
            case LAMBDA_FUNCTION_FAILED: {
                this.lambdaFunctionClient.handleLambdaFunctionFailed(event);
                break;
            }
            case LAMBDA_FUNCTION_TIMED_OUT: {
                this.lambdaFunctionClient.handleLambdaFunctionTimedOut(event);
                break;
            }
            case START_LAMBDA_FUNCTION_FAILED: {
                this.lambdaFunctionClient.handleStartLambdaFunctionFailed(event);
                break;
            }
            case SCHEDULE_LAMBDA_FUNCTION_FAILED: {
                this.lambdaFunctionClient.handleScheduleLambdaFunctionFailed(event);
                break;
            }
            case SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED: {
                this.decisionsHelper.handleSignalExternalWorkflowExecutionInitiated(event);
                break;
            }
            case REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_INITIATED: {
                this.decisionsHelper.handleRequestCancelExternalWorkflowExecutionInitiated(event);
                break;
            }
            case REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_FAILED: {
                this.decisionsHelper.handleRequestCancelExternalWorkflowExecutionFailed(event);
                break;
            }
            case START_CHILD_WORKFLOW_EXECUTION_INITIATED: {
                this.workflowClient.handleChildWorkflowExecutionInitiated(event);
                break;
            }
            case CANCEL_TIMER_FAILED: {
                this.decisionsHelper.handleCancelTimerFailed(event);
            }
        }
    }

    private void eventLoop(HistoryEvent event) throws Throwable {
        if (this.completed) {
            return;
        }
        try {
            this.completed = this.workflowAsyncScope.eventLoop();
        }
        catch (CancellationException e) {
            if (!this.cancelRequested) {
                this.failure = e;
            }
            this.completed = true;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            this.failure = e;
            this.completed = true;
        }
    }

    private void completeWorkflowIfCompleted() {
        if (this.hasCompletedWithoutUnhandledDecision()) {
            if (this.failure != null) {
                this.decisionsHelper.failWorkflowExecution(this.failure);
            } else if (this.cancelRequested) {
                this.decisionsHelper.cancelWorkflowExecution();
            } else {
                ContinueAsNewWorkflowExecutionParameters continueAsNewOnCompletion = this.workflowContext.getContinueAsNewOnCompletion();
                if (continueAsNewOnCompletion != null) {
                    this.decisionsHelper.continueAsNewWorkflowExecution(continueAsNewOnCompletion);
                } else {
                    Promise<String> output = this.workflowAsyncScope.getOutput();
                    if (output != null && output.isReady()) {
                        String workflowOutput = output.get();
                        this.decisionsHelper.completeWorkflowExecution(workflowOutput);
                    } else {
                        this.decisionsHelper.completeWorkflowExecution(null);
                    }
                }
            }
        }
    }

    private void handleDecisionTaskStarted(HistoryEvent event) throws Throwable {
    }

    private void handleWorkflowExecutionCancelRequested(HistoryEvent event) throws Throwable {
        this.workflowContext.setCancelRequested(true);
        this.workflowAsyncScope.cancel(new CancellationException());
        this.cancelRequested = true;
    }

    private void handleStartTimerFailed(HistoryEvent event) {
        StartTimerFailedEventAttributes attributes = event.startTimerFailedEventAttributes();
        String timerId = attributes.timerId();
        if (timerId.equals("FORCE_IMMEDIATE_DECISION")) {
            return;
        }
        this.workflowClock.handleStartTimerFailed(event);
    }

    private void handleTimerFired(HistoryEvent event) throws Throwable {
        TimerFiredEventAttributes attributes = event.timerFiredEventAttributes();
        String timerId = attributes.timerId();
        if (timerId.equals("FORCE_IMMEDIATE_DECISION")) {
            return;
        }
        this.workflowClock.handleTimerFired(event.eventId(), attributes);
    }

    private void handleTimerStarted(HistoryEvent event) {
        TimerStartedEventAttributes attributes = event.timerStartedEventAttributes();
        String timerId = attributes.timerId();
        if (timerId.equals("FORCE_IMMEDIATE_DECISION")) {
            return;
        }
        this.decisionsHelper.handleTimerStarted(event);
    }

    private void handleWorkflowExecutionSignaled(HistoryEvent event) throws Throwable {
        assert (event.eventTypeAsString().equals(EventType.WORKFLOW_EXECUTION_SIGNALED.toString()));
        final WorkflowExecutionSignaledEventAttributes signalAttributes = event.workflowExecutionSignaledEventAttributes();
        if (this.completed) {
            this.workflowAsyncScope = new UnhandledSignalAsyncScope(this.workflowAsyncScope.getOutput(), this.workflowAsyncScope.getFailure(), this.workflowAsyncScope.isCancelRequested());
            this.completed = false;
        }
        new Task(this.workflowAsyncScope, new Promise[0]){

            @Override
            protected void doExecute() throws Throwable {
                AsyncDecider.this.definition.signalRecieved(signalAttributes.signalName(), signalAttributes.input());
            }
        };
    }

    private void handleDecisionTaskCompleted(HistoryEvent event) {
        this.decisionsHelper.handleDecisionCompletion(event.decisionTaskCompletedEventAttributes());
    }

    public void decide() throws Exception {
        block32: {
            try {
                if (this.definition != null) {
                    CurrentDecisionContext.set(this.context);
                    if (this.savedWorkflowExecutionLocalValues == null) {
                        ThreadLocalMetrics.getMetrics().recordCount(MetricName.AFFINITY_WORKER_WORKFLOW_EXECUTION_LOCAL_FAILURE.getName(), 1.0);
                        log.error((Object)"Unable to restore WorkflowExecutionLocals for affinity worker. Your WorkflowExecutionLocals will not work as expected.");
                    } else {
                        WorkflowExecutionLocal.restoreFromSavedValues(this.savedWorkflowExecutionLocalValues);
                    }
                } else {
                    try {
                        this.definition = this.workflowDefinitionFactory.getWorkflowDefinition(this.context);
                    }
                    catch (Exception e) {
                        throw new Error("Failed to get workflow definition for " + this.context, e);
                    }
                }
                if (this.definition == null) {
                    WorkflowType workflowType = this.context.getWorkflowContext().getWorkflowType();
                    ThreadLocalMetrics.getMetrics().recordCount(MetricName.TYPE_NOT_FOUND.getName(), 1.0, MetricName.getWorkflowTypeDimension(workflowType));
                    throw new IllegalStateException("Null workflow definition returned for: " + workflowType);
                }
                this.decideImpl();
            }
            catch (AwsServiceException e) {
                if (e.isThrottlingException()) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Failing workflow " + this.workflowContext.getWorkflowExecution()), (Throwable)e);
                    }
                    this.decisionsHelper.failWorkflowDueToUnexpectedError(e);
                    break block32;
                }
                throw e;
            }
            catch (Error | SdkClientException e) {
                throw e;
            }
            catch (Throwable e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Failing workflow " + this.workflowContext.getWorkflowExecution()), e);
                }
                this.decisionsHelper.failWorkflowDueToUnexpectedError(e);
            }
            finally {
                try {
                    if (this.definition != null) {
                        this.decisionsHelper.setWorkflowContextData(this.definition.getWorkflowState());
                    }
                }
                catch (WorkflowException e) {
                    this.decisionsHelper.setWorkflowContextData(e.getDetails());
                }
                catch (Throwable e) {
                    this.decisionsHelper.setWorkflowContextData(e.getMessage());
                }
                if (this.definition != null) {
                    this.savedWorkflowExecutionLocalValues = WorkflowExecutionLocal.saveCurrentValues();
                    this.workflowDefinitionFactory.deleteWorkflowDefinition(this.definition);
                }
            }
        }
    }

    private void decideImpl() throws Throwable {
        List<HistoryEvent> singleDecisionEvents = this.historyHelper.getSingleDecisionEvents();
        while (singleDecisionEvents != null && singleDecisionEvents.size() > 0) {
            this.decisionsHelper.handleDecisionTaskStartedEvent();
            for (HistoryEvent event : singleDecisionEvents) {
                Long lastNonReplayedEventId = this.historyHelper.getLastNonReplayEventId();
                if (event.eventId() >= lastNonReplayedEventId) {
                    this.workflowClock.setReplaying(false);
                }
                long replayCurrentTimeMilliseconds = this.historyHelper.getReplayCurrentTimeMilliseconds();
                this.workflowClock.setReplayCurrentTimeMilliseconds(replayCurrentTimeMilliseconds);
                EventType eventType = EventType.fromValue((String)event.eventTypeAsString());
                this.processEvent(event, eventType);
                this.eventLoop(event);
            }
            this.completeWorkflowIfCompleted();
            singleDecisionEvents = this.historyHelper.getSingleDecisionEvents();
        }
        if (this.unhandledDecision) {
            this.unhandledDecision = false;
            this.completeWorkflowIfCompleted();
        }
    }

    public List<AsyncTaskInfo> getAsynchronousThreadDump() {
        this.checkAsynchronousThreadDumpState();
        return this.workflowAsyncScope.getAsynchronousThreadDump();
    }

    public String getAsynchronousThreadDumpAsString() {
        this.checkAsynchronousThreadDumpState();
        return this.workflowAsyncScope.getAsynchronousThreadDumpAsString();
    }

    private void checkAsynchronousThreadDumpState() {
        if (this.workflowAsyncScope == null) {
            throw new IllegalStateException("workflow hasn't started yet");
        }
        if (this.decisionsHelper.isWorkflowFailed()) {
            throw new IllegalStateException("Cannot get AsynchronousThreadDump of a failed workflow", this.decisionsHelper.getWorkflowFailureCause());
        }
    }

    public WorkflowDefinition getWorkflowDefinition() {
        return this.definition;
    }

    public void setHistoryHelper(HistoryHelper historyHelper) {
        this.historyHelper = historyHelper;
    }

    public HistoryHelper getHistoryHelper() {
        return this.historyHelper;
    }

    public DecisionsHelper getDecisionsHelper() {
        return this.decisionsHelper;
    }

    public String getOriginalTaskList() {
        return this.originalTaskList;
    }

    private final class UnhandledSignalAsyncScope
    extends WorkflowAsyncScope {
        private final Promise<String> output;
        private Throwable failure;
        private boolean cancellation;

        public UnhandledSignalAsyncScope(Promise<String> output, Throwable failure, boolean cancellation) {
            this.output = output;
            this.failure = failure;
            this.cancellation = cancellation;
        }

        @Override
        protected void doAsync() throws Throwable {
        }

        @Override
        public Promise<String> getOutput() {
            return this.output;
        }

        @Override
        public boolean isCancelRequested() {
            return super.isCancelRequested() || this.cancellation;
        }

        @Override
        public Throwable getFailure() {
            Throwable result = super.getFailure();
            if (this.failure != null) {
                result = this.failure;
            }
            return result;
        }

        @Override
        public boolean eventLoop() throws Throwable {
            boolean completed = super.eventLoop();
            if (completed && this.failure != null) {
                throw this.failure;
            }
            return completed;
        }
    }

    private final class WorkflowExecuteAsyncScope
    extends WorkflowAsyncScope {
        private final WorkflowExecutionStartedEventAttributes attributes;
        private Promise<String> output;

        public WorkflowExecuteAsyncScope(HistoryEvent event) {
            assert (event.eventTypeAsString().equals(EventType.WORKFLOW_EXECUTION_STARTED.toString()));
            this.attributes = event.workflowExecutionStartedEventAttributes();
        }

        @Override
        protected void doAsync() throws Throwable {
            this.output = AsyncDecider.this.definition.execute(this.attributes.input());
        }

        @Override
        public Promise<String> getOutput() {
            return this.output;
        }
    }

    private static abstract class WorkflowAsyncScope
    extends AsyncScope {
        public WorkflowAsyncScope() {
            super(false, true);
        }

        public abstract Promise<String> getOutput();
    }
}

