/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecider;
import com.amazonaws.services.simpleworkflow.flow.worker.HistoryHelper;
import com.amazonaws.services.simpleworkflow.flow.worker.WorkflowHistoryDecisionTaskIterator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;

public class AffinityHelper {
    private static final Log log = LogFactory.getLog(AffinityHelper.class);
    private SwfClient service;
    private String domain;
    private SimpleWorkflowClientConfig config;
    private boolean affinityWorker;
    private String affinityTaskList;
    private static final long MAXIMUM_PAGE_SIZE = 1000L;
    private static final double FORCE_FETCH_FULL_HISTORY_RATIO = 0.3;

    public AffinityHelper(SwfClient service, String domain, SimpleWorkflowClientConfig config, boolean affinityWorker) {
        this.service = service;
        this.domain = domain;
        this.config = config;
        this.affinityWorker = affinityWorker;
        this.affinityTaskList = this.getHostName();
    }

    public HistoryHelper createHistoryHelperForDecisionTask(PollForDecisionTaskResponse decisionTask) {
        return new HistoryHelper(new WorkflowHistoryDecisionTaskIterator(this.service, this.domain, decisionTask, this.config));
    }

    public AsyncDecider getDeciderForDecisionTask(PollForDecisionTaskResponse decisionTask) {
        WorkflowExecution workflowExecution = WorkflowExecution.fromSdkType(decisionTask.workflowExecution());
        AsyncDecider decider = (AsyncDecider)this.config.getDeciderAffinityConfig().getDeciderCache().get((Object)workflowExecution);
        if (this.isValidDecider(decisionTask, decider)) {
            return decider;
        }
        this.config.getDeciderAffinityConfig().getDeciderCache().remove((Object)workflowExecution);
        return null;
    }

    public WorkflowHistoryDecisionTaskIterator getHistoryIterator(PollForDecisionTaskResponse decisionTask) {
        return new WorkflowHistoryDecisionTaskIterator(this.service, this.domain, decisionTask, this.config);
    }

    public boolean shouldForceFetchFullHistory(PollForDecisionTaskResponse decisionTask) {
        return decisionTask.startedEventId() > 1000L && ThreadLocalRandom.current().nextDouble() < 0.3;
    }

    private String getHostName() {
        String result;
        String hostname = System.getenv("HOSTNAME");
        if (hostname != null && !"localhost".equalsIgnoreCase(hostname)) {
            result = hostname;
        } else {
            try {
                result = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                if (this.config.getDeciderAffinityConfig() != null) {
                    ThreadLocalMetrics.getMetrics().recordCount(MetricName.AFFINITY_WORKER_START_FAILURE.getName(), 1.0);
                    log.error((Object)"Unable to get host name when constructing affinity task list. Flow will run as if decider affinity is disabled.");
                }
                return null;
            }
        }
        if (result.length() > 256) {
            return result.substring(0, 256);
        }
        return result;
    }

    private boolean isValidDecider(PollForDecisionTaskResponse decisionTask, AsyncDecider decider) {
        return decider != null && decisionTask.previousStartedEventId().equals(decider.getHistoryHelper().getDecisionTask().startedEventId());
    }

    public boolean isAffinityWorker() {
        return this.affinityWorker;
    }

    public String getAffinityTaskList() {
        return this.affinityTaskList;
    }
}

