/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.ActivityExecutionContext;
import com.amazonaws.services.simpleworkflow.flow.common.RequestTimeoutHelper;
import com.amazonaws.services.simpleworkflow.flow.config.SimpleWorkflowClientConfig;
import com.amazonaws.services.simpleworkflow.flow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricHelper;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.Metrics;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricsRegistry;
import com.amazonaws.services.simpleworkflow.flow.monitoring.ThreadLocalMetrics;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.services.swf.SwfClient;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatRequest;
import software.amazon.awssdk.services.swf.model.RecordActivityTaskHeartbeatResponse;
import software.amazon.awssdk.services.swf.model.SwfRequest;

class ActivityExecutionContextImpl
extends ActivityExecutionContext {
    private final SwfClient service;
    private final String domain;
    private final SimpleWorkflowClientConfig config;
    private final MetricsRegistry metricsRegistry;

    public ActivityExecutionContextImpl(SwfClient service, String domain, ActivityTask task) {
        this(service, domain, task, null, ThreadLocalMetrics.getMetrics().getMetricsRegistry());
    }

    public ActivityExecutionContextImpl(SwfClient service, String domain, ActivityTask task, SimpleWorkflowClientConfig config, MetricsRegistry metricsRegistry) {
        super(task);
        this.domain = domain;
        this.service = service;
        this.config = config;
        this.metricsRegistry = metricsRegistry;
    }

    @Override
    public void recordActivityHeartbeat(String details) throws CancellationException {
        RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest = (RecordActivityTaskHeartbeatRequest)RequestTimeoutHelper.overrideDataPlaneRequestTimeout((SwfRequest)RecordActivityTaskHeartbeatRequest.builder().taskToken(this.getTask().getTaskToken()).details(details).build(), this.config);
        try (Metrics metrics = this.metricsRegistry.newMetrics(MetricName.Operation.EXECUTE_ACTIVITY_TASK.getName());){
            MetricHelper.recordMetrics(this.getTask(), metrics);
            RecordActivityTaskHeartbeatResponse status = metrics.recordSupplier(() -> this.service.recordActivityTaskHeartbeat(recordActivityTaskHeartbeatRequest), MetricName.Operation.RECORD_ACTIVITY_TASK_HEARTBEAT.getName(), TimeUnit.MILLISECONDS);
            boolean isCancelRequested = status.cancelRequested();
            metrics.recordCount(MetricName.ACTIVITY_CANCEL_REQUESTED.getName(), isCancelRequested);
            if (isCancelRequested) {
                throw new CancellationException();
            }
        }
    }

    @Override
    public SwfClient getService() {
        return this.service;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }
}

