/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.retry;

import com.amazonaws.services.simpleworkflow.flow.retry.Retrier;
import com.amazonaws.services.simpleworkflow.flow.worker.BackoffThrottler;
import com.amazonaws.services.simpleworkflow.flow.worker.ExponentialRetryParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynchronousRetrier
extends Retrier {
    private static final Log logger = LogFactory.getLog(SynchronousRetrier.class);
    private final Class<?>[] exceptionsToNotRetry;

    public SynchronousRetrier(ExponentialRetryParameters retryParameters, Class<?> ... exceptionsToNotRetry) {
        super(retryParameters, logger);
        this.exceptionsToNotRetry = exceptionsToNotRetry;
    }

    public Class<?>[] getExceptionsToNotRetry() {
        return this.exceptionsToNotRetry;
    }

    @Override
    protected BackoffThrottler createBackoffThrottler() {
        return new BackoffThrottler(this.getRetryParameters().getInitialInterval(), this.getRetryParameters().getMaximumRetryInterval(), this.getRetryParameters().getBackoffCoefficient());
    }

    @Override
    protected boolean shouldRetry(RuntimeException e) {
        for (Class<?> exceptionToNotRetry : this.getExceptionsToNotRetry()) {
            if (!exceptionToNotRetry.isAssignableFrom(e.getClass())) continue;
            return false;
        }
        return true;
    }
}

