/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.monitoring;

import com.amazonaws.services.simpleworkflow.flow.monitoring.Metrics;
import com.amazonaws.services.simpleworkflow.flow.monitoring.NullMetricsRegistry;

public class ThreadLocalMetrics {
    private static final Metrics NULL_METRICS = NullMetricsRegistry.getInstance().newMetrics();
    private static final ThreadLocal<Context> THREAD_CONTEXT = new ThreadLocal();

    private static Context getOrCreateCurrentContext() {
        Context context = THREAD_CONTEXT.get();
        if (context == null) {
            context = new Context(NULL_METRICS);
            THREAD_CONTEXT.set(context);
        }
        return context;
    }

    public static void clearCurrent() {
        THREAD_CONTEXT.remove();
    }

    public static void setCurrent(Metrics metrics) {
        ThreadLocalMetrics.clearCurrent();
        Context context = new Context(metrics);
        THREAD_CONTEXT.set(context);
    }

    public static Metrics getMetrics() {
        return ThreadLocalMetrics.getOrCreateCurrentContext().getMetrics();
    }

    private static final class Context {
        private final Metrics metrics;

        public Context(Metrics metrics) {
            this.metrics = metrics;
        }

        public Metrics getMetrics() {
            return this.metrics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            Metrics this$metrics = this.getMetrics();
            Metrics other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !this$metrics.equals(other$metrics));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Metrics $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : $metrics.hashCode());
            return result;
        }

        public String toString() {
            return "ThreadLocalMetrics.Context(metrics=" + this.getMetrics() + ")";
        }
    }
}

