/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.monitoring;

import com.amazonaws.services.simpleworkflow.flow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.flow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowType;
import com.amazonaws.services.simpleworkflow.flow.monitoring.MetricName;
import com.amazonaws.services.simpleworkflow.flow.monitoring.Metrics;
import software.amazon.awssdk.services.swf.model.PollForDecisionTaskResponse;

public class MetricHelper {
    public static void recordMetrics(PollForDecisionTaskResponse decisionTask, Metrics metrics) {
        metrics.addProperty(MetricName.Property.TASK_STARTED_EVENT_ID.getName(), decisionTask.startedEventId().toString());
        metrics.addProperty(MetricName.Property.TASK_TOKEN.getName(), decisionTask.taskToken());
        MetricHelper.recordMetrics(WorkflowExecution.fromSdkType(decisionTask.workflowExecution()), metrics);
        MetricHelper.recordMetrics(WorkflowType.fromSdkType(decisionTask.workflowType()), metrics);
    }

    public static void recordMetrics(ActivityTask activityTask, Metrics metrics) {
        metrics.addProperty(MetricName.Property.TASK_STARTED_EVENT_ID.getName(), activityTask.getStartedEventId().toString());
        metrics.addProperty(MetricName.Property.TASK_TOKEN.getName(), activityTask.getTaskToken());
        MetricHelper.recordMetrics(activityTask.getWorkflowExecution(), metrics);
        MetricHelper.recordMetrics(activityTask.getActivityType(), metrics);
    }

    public static void recordMetrics(WorkflowExecution workflowExecution, Metrics metrics) {
        metrics.addProperty(MetricName.Property.WORKFLOW_ID.getName(), workflowExecution.getWorkflowId());
        metrics.addProperty(MetricName.Property.RUN_ID.getName(), workflowExecution.getRunId());
    }

    public static void recordMetrics(WorkflowType workflowType, Metrics metrics) {
        metrics.addProperty(MetricName.Property.WORKFLOW_TYPE.getName(), workflowType.getName() + "@" + workflowType.getVersion());
        metrics.addProperty(MetricName.Property.WORKFLOW_TYPE_NAME.getName(), workflowType.getName());
        metrics.addProperty(MetricName.Property.WORKFLOW_TYPE_VERSION.getName(), workflowType.getVersion());
    }

    public static void recordMetrics(ActivityType activityType, Metrics metrics) {
        metrics.addProperty(MetricName.Property.ACTIVITY_TYPE.getName(), activityType.getName() + "@" + activityType.getVersion());
        metrics.addProperty(MetricName.Property.ACTIVITY_TYPE_NAME.getName(), activityType.getName());
        metrics.addProperty(MetricName.Property.ACTIVITY_TYPE_VERSION.getName(), activityType.getVersion());
    }
}

