/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.interceptors.ExponentialRetryPolicy;
import java.util.Date;
import java.util.Random;

public class ExponentialRetryWithJitterPolicy
extends ExponentialRetryPolicy {
    private final Random jitterCoefficientGenerator;
    private final double maxJitterCoefficient;

    public ExponentialRetryWithJitterPolicy(long initialRetryIntervalSeconds, Random jitterCoefficientGenerator, double maxJitterCoefficient) {
        super(initialRetryIntervalSeconds);
        this.jitterCoefficientGenerator = jitterCoefficientGenerator;
        this.maxJitterCoefficient = maxJitterCoefficient;
    }

    @Override
    public long nextRetryDelaySeconds(Date firstAttempt, Date recordedFailure, int numberOfTries) {
        long totalDelay;
        long baseDelay = super.nextRetryDelaySeconds(firstAttempt, recordedFailure, numberOfTries);
        if (baseDelay == -1L) {
            totalDelay = baseDelay;
        } else {
            long jitter = Math.round((double)baseDelay * this.maxJitterCoefficient * (2.0 * this.jitterCoefficientGenerator.nextDouble() - 1.0));
            totalDelay = baseDelay + jitter;
        }
        return totalDelay;
    }

    @Override
    public void validate() throws IllegalStateException {
        super.validate();
        if (this.jitterCoefficientGenerator == null) {
            throw new IllegalStateException("ExponentialRetryWithJitterPolicy requires jitterCoefficientGenerator not to be null.");
        }
        if (this.maxJitterCoefficient <= 0.0 || this.maxJitterCoefficient >= 1.0) {
            throw new IllegalStateException("ExponentialRetryWithJitterPolicy requires maxJitterCoefficient to be exclusively between 0 and 1.");
        }
    }
}

