/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.interceptors;

import com.amazonaws.services.simpleworkflow.flow.WorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.core.TryCatchFinally;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncExecutor;
import com.amazonaws.services.simpleworkflow.flow.interceptors.AsyncRunnable;
import com.amazonaws.services.simpleworkflow.flow.interceptors.RetryPolicy;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;

public class AsyncRetryingExecutor
implements AsyncExecutor {
    private final RetryPolicy retryPolicy;
    private WorkflowClock clock;
    private AtomicLong firstAttemptTime;

    public AsyncRetryingExecutor(RetryPolicy retryPolicy, WorkflowClock clock, AtomicLong firstAttemptTime) {
        this.retryPolicy = retryPolicy;
        this.clock = clock;
        this.firstAttemptTime = firstAttemptTime;
    }

    public AsyncRetryingExecutor(RetryPolicy retryPolicy, WorkflowClock clock) {
        this(retryPolicy, clock, new AtomicLong(0L));
    }

    @Override
    public void execute(final AsyncRunnable command) {
        new Task(new Promise[0]){

            @Override
            protected void doExecute() throws Throwable {
                AsyncRetryingExecutor.this.scheduleWithRetry(command, null, 1, AsyncRetryingExecutor.this.clock.currentTimeMillis(), 0L);
            }
        };
    }

    private void scheduleWithRetry(final AsyncRunnable command, Throwable failure, final int attempt, final long timeOfFirstAttempt, long timeOfRecordedFailure) throws Throwable {
        long delay = -1L;
        if (attempt > 1) {
            if (!this.retryPolicy.isRetryable(failure)) {
                throw failure;
            }
            Date firstAttempt = this.firstAttemptTime.get() == 0L ? new Date(timeOfFirstAttempt) : new Date(this.firstAttemptTime.get());
            delay = this.retryPolicy.nextRetryDelaySeconds(firstAttempt, new Date(timeOfRecordedFailure), attempt);
            if (delay < 0L) {
                throw failure;
            }
        }
        if (delay > 0L) {
            Promise<Void> timer = this.clock.createTimer(delay);
            new Task(new Promise[]{timer}){

                @Override
                protected void doExecute() throws Throwable {
                    AsyncRetryingExecutor.this.invoke(command, attempt, timeOfFirstAttempt);
                }
            };
        } else {
            this.invoke(command, attempt, timeOfFirstAttempt);
        }
    }

    private void invoke(final AsyncRunnable command, final int attempt, final long timeOfFirstAttempt) {
        final Settable shouldRetry = new Settable();
        new TryCatchFinally(){
            Throwable failureToRetry = null;

            @Override
            protected void doTry() throws Throwable {
                command.run();
            }

            @Override
            protected void doCatch(Throwable failure) throws Throwable {
                if (failure instanceof CancellationException) {
                    throw failure;
                }
                this.failureToRetry = failure;
            }

            @Override
            protected void doFinally() throws Throwable {
                shouldRetry.set(this.failureToRetry);
            }
        };
        new Task(new Promise[]{shouldRetry}){

            @Override
            protected void doExecute() throws Throwable {
                Throwable failure = (Throwable)shouldRetry.get();
                if (failure != null) {
                    AsyncRetryingExecutor.this.scheduleWithRetry(command, failure, attempt + 1, timeOfFirstAttempt, AsyncRetryingExecutor.this.clock.currentTimeMillis());
                }
            }
        };
    }
}

