/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.config;

import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.flow.model.WorkflowExecutionMetadata;
import com.amazonaws.services.simpleworkflow.flow.worker.AsyncDecider;
import java.time.Duration;
import java.util.function.Predicate;
import javax.cache.Cache;

public class DeciderAffinityConfig {
    private final Duration affinityTaskListScheduleToStartTimeout;
    private final Cache<WorkflowExecution, AsyncDecider> deciderCache;
    private final Predicate<WorkflowExecutionMetadata> establishAffinityPredicate;

    public DeciderAffinityConfig(Duration affinityTaskListScheduleToStartTimeout, Cache<WorkflowExecution, AsyncDecider> deciderCache) {
        this(affinityTaskListScheduleToStartTimeout, deciderCache, workflowExecutionMetadata -> true);
    }

    public DeciderAffinityConfig(Duration affinityTaskListScheduleToStartTimeout, Cache<WorkflowExecution, AsyncDecider> deciderCache, Predicate<WorkflowExecutionMetadata> establishAffinityPredicate) {
        if (affinityTaskListScheduleToStartTimeout == null) {
            throw new IllegalArgumentException("Trying to create a decider affinity config while affinityTaskListScheduleToStartTimeout is not provided");
        }
        if (deciderCache == null) {
            throw new IllegalArgumentException("Trying to create a decider affinity config while deciderCache is not provided");
        }
        if (establishAffinityPredicate == null) {
            throw new IllegalArgumentException("Trying to create a decider affinity config while setting establishAffinityPredicate to null");
        }
        this.affinityTaskListScheduleToStartTimeout = affinityTaskListScheduleToStartTimeout;
        this.deciderCache = deciderCache;
        this.establishAffinityPredicate = establishAffinityPredicate;
    }

    public Duration getAffinityTaskListScheduleToStartTimeout() {
        return this.affinityTaskListScheduleToStartTimeout;
    }

    public Cache<WorkflowExecution, AsyncDecider> getDeciderCache() {
        return this.deciderCache;
    }

    public Predicate<WorkflowExecutionMetadata> getEstablishAffinityPredicate() {
        return this.establishAffinityPredicate;
    }
}

