/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.test;

import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProviderImpl;
import com.amazonaws.services.simpleworkflow.flow.LambdaFunctionException;
import com.amazonaws.services.simpleworkflow.flow.LambdaFunctionFailedException;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.test.TestLambdaFunctionInvoker;
import com.amazonaws.services.simpleworkflow.flow.worker.LambdaFunctionClient;

public class TestLambdaFunctionClient
implements LambdaFunctionClient {
    protected final DecisionContextProvider decisionContextProvider = new DecisionContextProviderImpl();
    protected TestLambdaFunctionInvoker invoker;

    @Override
    public Promise<String> scheduleLambdaFunction(String name, String input) {
        return this.scheduleLambdaFunction(name, input, 60L);
    }

    @Override
    public Promise<String> scheduleLambdaFunction(String name, Promise<String> input) {
        return this.scheduleLambdaFunction(name, input, 60L);
    }

    @Override
    public Promise<String> scheduleLambdaFunction(final String name, final Promise<String> input, final long timeoutSeconds) {
        final Settable<String> result = new Settable<String>();
        new Task(new Promise[]{input}){

            @Override
            protected void doExecute() throws Throwable {
                result.chain(TestLambdaFunctionClient.this.scheduleLambdaFunction(name, (String)input.get(), timeoutSeconds));
            }
        };
        return result;
    }

    @Override
    public Promise<String> scheduleLambdaFunction(String name, String input, long timeoutSeconds) {
        String id = this.decisionContextProvider.getDecisionContext().getWorkflowClient().generateUniqueId();
        Settable<String> result = new Settable<String>();
        try {
            result.set(this.invoker.invoke(name, input, timeoutSeconds));
        }
        catch (Throwable e) {
            if (e instanceof LambdaFunctionException) {
                throw (LambdaFunctionException)e;
            }
            LambdaFunctionFailedException failure = new LambdaFunctionFailedException(0L, name, id, e.getMessage());
            failure.initCause(e);
            throw failure;
        }
        return result;
    }

    public void setInvoker(TestLambdaFunctionInvoker invoker) {
        this.invoker = invoker;
    }
}

