/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.support.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Time range object with <code>startTime</code> and <code>endTime</code> range in RFC 3339 format.
 * <code>'HH:mm:ss.SSS'</code>.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/SupportedHour" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SupportedHour implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Start Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     * </p>
     */
    private String startTime;
    /**
     * <p>
     * End Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     * </p>
     */
    private String endTime;

    /**
     * <p>
     * Start Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     * </p>
     * 
     * @param startTime
     *        Start Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     */

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    /**
     * <p>
     * Start Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     * </p>
     * 
     * @return Start Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     */

    public String getStartTime() {
        return this.startTime;
    }

    /**
     * <p>
     * Start Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     * </p>
     * 
     * @param startTime
     *        Start Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SupportedHour withStartTime(String startTime) {
        setStartTime(startTime);
        return this;
    }

    /**
     * <p>
     * End Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     * </p>
     * 
     * @param endTime
     *        End Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     */

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    /**
     * <p>
     * End Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     * </p>
     * 
     * @return End Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     */

    public String getEndTime() {
        return this.endTime;
    }

    /**
     * <p>
     * End Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     * </p>
     * 
     * @param endTime
     *        End Time. RFC 3339 format <code>'HH:mm:ss.SSS'</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SupportedHour withEndTime(String endTime) {
        setEndTime(endTime);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStartTime() != null)
            sb.append("StartTime: ").append(getStartTime()).append(",");
        if (getEndTime() != null)
            sb.append("EndTime: ").append(getEndTime());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SupportedHour == false)
            return false;
        SupportedHour other = (SupportedHour) obj;
        if (other.getStartTime() == null ^ this.getStartTime() == null)
            return false;
        if (other.getStartTime() != null && other.getStartTime().equals(this.getStartTime()) == false)
            return false;
        if (other.getEndTime() == null ^ this.getEndTime() == null)
            return false;
        if (other.getEndTime() != null && other.getEndTime().equals(this.getEndTime()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStartTime() == null) ? 0 : getStartTime().hashCode());
        hashCode = prime * hashCode + ((getEndTime() == null) ? 0 : getEndTime().hashCode());
        return hashCode;
    }

    @Override
    public SupportedHour clone() {
        try {
            return (SupportedHour) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.support.model.transform.SupportedHourMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
