/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.support.model.AddAttachmentsToSetRequest;
import com.amazonaws.services.support.model.Attachment;
import com.amazonaws.services.support.model.transform.AttachmentJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AddAttachmentsToSetRequestMarshaller
implements Marshaller<Request<AddAttachmentsToSetRequest>, AddAttachmentsToSetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AddAttachmentsToSetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AddAttachmentsToSetRequest> marshall(AddAttachmentsToSetRequest addAttachmentsToSetRequest) {
        if (addAttachmentsToSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addAttachmentsToSetRequest, "AWSSupport");
        request.addHeader("X-Amz-Target", "AWSSupport_20130415.AddAttachmentsToSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList attachmentsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (addAttachmentsToSetRequest.getAttachmentSetId() != null) {
                jsonGenerator.writeFieldName("attachmentSetId").writeValue(addAttachmentsToSetRequest.getAttachmentSetId());
            }
            if (!(attachmentsList = (SdkInternalList)addAttachmentsToSetRequest.getAttachments()).isEmpty() || !attachmentsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("attachments");
                jsonGenerator.writeStartArray();
                for (Attachment attachmentsListValue : attachmentsList) {
                    if (attachmentsListValue == null) continue;
                    AttachmentJsonMarshaller.getInstance().marshall(attachmentsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

