/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.supplychain;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.supplychain.AWSSupplyChain;
import com.amazonaws.services.supplychain.AWSSupplyChainClientBuilder;
import com.amazonaws.services.supplychain.model.AWSSupplyChainException;
import com.amazonaws.services.supplychain.model.CreateBillOfMaterialsImportJobRequest;
import com.amazonaws.services.supplychain.model.CreateBillOfMaterialsImportJobResult;
import com.amazonaws.services.supplychain.model.GetBillOfMaterialsImportJobRequest;
import com.amazonaws.services.supplychain.model.GetBillOfMaterialsImportJobResult;
import com.amazonaws.services.supplychain.model.SendDataIntegrationEventRequest;
import com.amazonaws.services.supplychain.model.SendDataIntegrationEventResult;
import com.amazonaws.services.supplychain.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.supplychain.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.supplychain.model.transform.CreateBillOfMaterialsImportJobRequestProtocolMarshaller;
import com.amazonaws.services.supplychain.model.transform.CreateBillOfMaterialsImportJobResultJsonUnmarshaller;
import com.amazonaws.services.supplychain.model.transform.GetBillOfMaterialsImportJobRequestProtocolMarshaller;
import com.amazonaws.services.supplychain.model.transform.GetBillOfMaterialsImportJobResultJsonUnmarshaller;
import com.amazonaws.services.supplychain.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.supplychain.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.supplychain.model.transform.SendDataIntegrationEventRequestProtocolMarshaller;
import com.amazonaws.services.supplychain.model.transform.SendDataIntegrationEventResultJsonUnmarshaller;
import com.amazonaws.services.supplychain.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.supplychain.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.supplychain.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSSupplyChainClient
extends AmazonWebServiceClient
implements AWSSupplyChain {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSupplyChain.class);
    private static final String DEFAULT_SIGNING_NAME = "scn";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSSupplyChainException.class));

    public static AWSSupplyChainClientBuilder builder() {
        return AWSSupplyChainClientBuilder.standard();
    }

    AWSSupplyChainClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSupplyChainClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("scn.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/supplychain/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/supplychain/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateBillOfMaterialsImportJobResult createBillOfMaterialsImportJob(CreateBillOfMaterialsImportJobRequest request) {
        request = (CreateBillOfMaterialsImportJobRequest)this.beforeClientExecution(request);
        return this.executeCreateBillOfMaterialsImportJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBillOfMaterialsImportJobResult executeCreateBillOfMaterialsImportJob(CreateBillOfMaterialsImportJobRequest createBillOfMaterialsImportJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBillOfMaterialsImportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBillOfMaterialsImportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBillOfMaterialsImportJobRequestProtocolMarshaller(protocolFactory).marshall((CreateBillOfMaterialsImportJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBillOfMaterialsImportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SupplyChain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBillOfMaterialsImportJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBillOfMaterialsImportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBillOfMaterialsImportJobResult createBillOfMaterialsImportJobResult = (CreateBillOfMaterialsImportJobResult)response.getAwsResponse();
            return createBillOfMaterialsImportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBillOfMaterialsImportJobResult getBillOfMaterialsImportJob(GetBillOfMaterialsImportJobRequest request) {
        request = (GetBillOfMaterialsImportJobRequest)this.beforeClientExecution(request);
        return this.executeGetBillOfMaterialsImportJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBillOfMaterialsImportJobResult executeGetBillOfMaterialsImportJob(GetBillOfMaterialsImportJobRequest getBillOfMaterialsImportJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBillOfMaterialsImportJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBillOfMaterialsImportJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBillOfMaterialsImportJobRequestProtocolMarshaller(protocolFactory).marshall((GetBillOfMaterialsImportJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBillOfMaterialsImportJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SupplyChain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBillOfMaterialsImportJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBillOfMaterialsImportJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBillOfMaterialsImportJobResult getBillOfMaterialsImportJobResult = (GetBillOfMaterialsImportJobResult)response.getAwsResponse();
            return getBillOfMaterialsImportJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SendDataIntegrationEventResult sendDataIntegrationEvent(SendDataIntegrationEventRequest request) {
        request = (SendDataIntegrationEventRequest)this.beforeClientExecution(request);
        return this.executeSendDataIntegrationEvent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SendDataIntegrationEventResult executeSendDataIntegrationEvent(SendDataIntegrationEventRequest sendDataIntegrationEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendDataIntegrationEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendDataIntegrationEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendDataIntegrationEventRequestProtocolMarshaller(protocolFactory).marshall((SendDataIntegrationEventRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendDataIntegrationEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SupplyChain");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SendDataIntegrationEvent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendDataIntegrationEventResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendDataIntegrationEventResult sendDataIntegrationEventResult = (SendDataIntegrationEventResult)response.getAwsResponse();
            return sendDataIntegrationEventResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

