/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.storagegateway.model.Disk;
import java.util.List;

@SdkInternalApi
public class DiskMarshaller {
    private static final MarshallingInfo<String> DISKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DiskId").build();
    private static final MarshallingInfo<String> DISKPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DiskPath").build();
    private static final MarshallingInfo<String> DISKNODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DiskNode").build();
    private static final MarshallingInfo<String> DISKSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DiskStatus").build();
    private static final MarshallingInfo<Long> DISKSIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DiskSizeInBytes").build();
    private static final MarshallingInfo<String> DISKALLOCATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DiskAllocationType").build();
    private static final MarshallingInfo<String> DISKALLOCATIONRESOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DiskAllocationResource").build();
    private static final MarshallingInfo<List> DISKATTRIBUTELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DiskAttributeList").build();
    private static final DiskMarshaller instance = new DiskMarshaller();

    public static DiskMarshaller getInstance() {
        return instance;
    }

    public void marshall(Disk disk, ProtocolMarshaller protocolMarshaller) {
        if (disk == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)disk.getDiskId(), DISKID_BINDING);
            protocolMarshaller.marshall((Object)disk.getDiskPath(), DISKPATH_BINDING);
            protocolMarshaller.marshall((Object)disk.getDiskNode(), DISKNODE_BINDING);
            protocolMarshaller.marshall((Object)disk.getDiskStatus(), DISKSTATUS_BINDING);
            protocolMarshaller.marshall((Object)disk.getDiskSizeInBytes(), DISKSIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)disk.getDiskAllocationType(), DISKALLOCATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)disk.getDiskAllocationResource(), DISKALLOCATIONRESOURCE_BINDING);
            protocolMarshaller.marshall(disk.getDiskAttributeList(), DISKATTRIBUTELIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

