/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.storagegateway.model.Disk;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class DiskJsonMarshaller {
    private static DiskJsonMarshaller instance;

    public void marshall(Disk disk, StructuredJsonGenerator jsonGenerator) {
        if (disk == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (disk.getDiskId() != null) {
                jsonGenerator.writeFieldName("DiskId").writeValue(disk.getDiskId());
            }
            if (disk.getDiskPath() != null) {
                jsonGenerator.writeFieldName("DiskPath").writeValue(disk.getDiskPath());
            }
            if (disk.getDiskNode() != null) {
                jsonGenerator.writeFieldName("DiskNode").writeValue(disk.getDiskNode());
            }
            if (disk.getDiskStatus() != null) {
                jsonGenerator.writeFieldName("DiskStatus").writeValue(disk.getDiskStatus());
            }
            if (disk.getDiskSizeInBytes() != null) {
                jsonGenerator.writeFieldName("DiskSizeInBytes").writeValue(disk.getDiskSizeInBytes().longValue());
            }
            if (disk.getDiskAllocationType() != null) {
                jsonGenerator.writeFieldName("DiskAllocationType").writeValue(disk.getDiskAllocationType());
            }
            if (disk.getDiskAllocationResource() != null) {
                jsonGenerator.writeFieldName("DiskAllocationResource").writeValue(disk.getDiskAllocationResource());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DiskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DiskJsonMarshaller();
        }
        return instance;
    }
}

