/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.storagegateway.model.CreateTapesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateTapesRequestMarshaller
implements Marshaller<Request<CreateTapesRequest>, CreateTapesRequest> {
    public Request<CreateTapesRequest> marshall(CreateTapesRequest createTapesRequest) {
        if (createTapesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTapesRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.CreateTapes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createTapesRequest.getGatewayARN() != null) {
                jsonGenerator.writeFieldName("GatewayARN").writeValue(createTapesRequest.getGatewayARN());
            }
            if (createTapesRequest.getTapeSizeInBytes() != null) {
                jsonGenerator.writeFieldName("TapeSizeInBytes").writeValue(createTapesRequest.getTapeSizeInBytes().longValue());
            }
            if (createTapesRequest.getClientToken() != null) {
                jsonGenerator.writeFieldName("ClientToken").writeValue(createTapesRequest.getClientToken());
            }
            if (createTapesRequest.getNumTapesToCreate() != null) {
                jsonGenerator.writeFieldName("NumTapesToCreate").writeValue((long)createTapesRequest.getNumTapesToCreate().intValue());
            }
            if (createTapesRequest.getTapeBarcodePrefix() != null) {
                jsonGenerator.writeFieldName("TapeBarcodePrefix").writeValue(createTapesRequest.getTapeBarcodePrefix());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

