/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sso;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sso.AWSSSOAsync;
import com.amazonaws.services.sso.AWSSSOAsyncClientBuilder;
import com.amazonaws.services.sso.AWSSSOClient;
import com.amazonaws.services.sso.model.GetRoleCredentialsRequest;
import com.amazonaws.services.sso.model.GetRoleCredentialsResult;
import com.amazonaws.services.sso.model.ListAccountRolesRequest;
import com.amazonaws.services.sso.model.ListAccountRolesResult;
import com.amazonaws.services.sso.model.ListAccountsRequest;
import com.amazonaws.services.sso.model.ListAccountsResult;
import com.amazonaws.services.sso.model.LogoutRequest;
import com.amazonaws.services.sso.model.LogoutResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSSOAsyncClient
extends AWSSSOClient
implements AWSSSOAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSSOAsyncClientBuilder asyncBuilder() {
        return AWSSSOAsyncClientBuilder.standard();
    }

    AWSSSOAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSSOAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetRoleCredentialsResult> getRoleCredentialsAsync(GetRoleCredentialsRequest request) {
        return this.getRoleCredentialsAsync(request, null);
    }

    @Override
    public Future<GetRoleCredentialsResult> getRoleCredentialsAsync(GetRoleCredentialsRequest request, final AsyncHandler<GetRoleCredentialsRequest, GetRoleCredentialsResult> asyncHandler) {
        final GetRoleCredentialsRequest finalRequest = (GetRoleCredentialsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRoleCredentialsResult>(){

            @Override
            public GetRoleCredentialsResult call() throws Exception {
                GetRoleCredentialsResult result = null;
                try {
                    result = AWSSSOAsyncClient.this.executeGetRoleCredentials(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccountRolesResult> listAccountRolesAsync(ListAccountRolesRequest request) {
        return this.listAccountRolesAsync(request, null);
    }

    @Override
    public Future<ListAccountRolesResult> listAccountRolesAsync(ListAccountRolesRequest request, final AsyncHandler<ListAccountRolesRequest, ListAccountRolesResult> asyncHandler) {
        final ListAccountRolesRequest finalRequest = (ListAccountRolesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccountRolesResult>(){

            @Override
            public ListAccountRolesResult call() throws Exception {
                ListAccountRolesResult result = null;
                try {
                    result = AWSSSOAsyncClient.this.executeListAccountRoles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccountsResult> listAccountsAsync(ListAccountsRequest request) {
        return this.listAccountsAsync(request, null);
    }

    @Override
    public Future<ListAccountsResult> listAccountsAsync(ListAccountsRequest request, final AsyncHandler<ListAccountsRequest, ListAccountsResult> asyncHandler) {
        final ListAccountsRequest finalRequest = (ListAccountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccountsResult>(){

            @Override
            public ListAccountsResult call() throws Exception {
                ListAccountsResult result = null;
                try {
                    result = AWSSSOAsyncClient.this.executeListAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<LogoutResult> logoutAsync(LogoutRequest request) {
        return this.logoutAsync(request, null);
    }

    @Override
    public Future<LogoutResult> logoutAsync(LogoutRequest request, final AsyncHandler<LogoutRequest, LogoutResult> asyncHandler) {
        final LogoutRequest finalRequest = (LogoutRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<LogoutResult>(){

            @Override
            public LogoutResult call() throws Exception {
                LogoutResult result = null;
                try {
                    result = AWSSSOAsyncClient.this.executeLogout(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

