/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmcontacts.model.CoverageTime;
import com.amazonaws.services.ssmcontacts.model.HandOffTime;
import com.amazonaws.services.ssmcontacts.model.MonthlySetting;
import com.amazonaws.services.ssmcontacts.model.WeeklySetting;
import com.amazonaws.services.ssmcontacts.model.transform.RecurrenceSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecurrenceSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<MonthlySetting> monthlySettings;
    private List<WeeklySetting> weeklySettings;
    private List<HandOffTime> dailySettings;
    private Integer numberOfOnCalls;
    private Map<String, List<CoverageTime>> shiftCoverages;
    private Integer recurrenceMultiplier;

    public List<MonthlySetting> getMonthlySettings() {
        return this.monthlySettings;
    }

    public void setMonthlySettings(Collection<MonthlySetting> monthlySettings) {
        if (monthlySettings == null) {
            this.monthlySettings = null;
            return;
        }
        this.monthlySettings = new ArrayList<MonthlySetting>(monthlySettings);
    }

    public RecurrenceSettings withMonthlySettings(MonthlySetting ... monthlySettings) {
        if (this.monthlySettings == null) {
            this.setMonthlySettings(new ArrayList<MonthlySetting>(monthlySettings.length));
        }
        for (MonthlySetting ele : monthlySettings) {
            this.monthlySettings.add(ele);
        }
        return this;
    }

    public RecurrenceSettings withMonthlySettings(Collection<MonthlySetting> monthlySettings) {
        this.setMonthlySettings(monthlySettings);
        return this;
    }

    public List<WeeklySetting> getWeeklySettings() {
        return this.weeklySettings;
    }

    public void setWeeklySettings(Collection<WeeklySetting> weeklySettings) {
        if (weeklySettings == null) {
            this.weeklySettings = null;
            return;
        }
        this.weeklySettings = new ArrayList<WeeklySetting>(weeklySettings);
    }

    public RecurrenceSettings withWeeklySettings(WeeklySetting ... weeklySettings) {
        if (this.weeklySettings == null) {
            this.setWeeklySettings(new ArrayList<WeeklySetting>(weeklySettings.length));
        }
        for (WeeklySetting ele : weeklySettings) {
            this.weeklySettings.add(ele);
        }
        return this;
    }

    public RecurrenceSettings withWeeklySettings(Collection<WeeklySetting> weeklySettings) {
        this.setWeeklySettings(weeklySettings);
        return this;
    }

    public List<HandOffTime> getDailySettings() {
        return this.dailySettings;
    }

    public void setDailySettings(Collection<HandOffTime> dailySettings) {
        if (dailySettings == null) {
            this.dailySettings = null;
            return;
        }
        this.dailySettings = new ArrayList<HandOffTime>(dailySettings);
    }

    public RecurrenceSettings withDailySettings(HandOffTime ... dailySettings) {
        if (this.dailySettings == null) {
            this.setDailySettings(new ArrayList<HandOffTime>(dailySettings.length));
        }
        for (HandOffTime ele : dailySettings) {
            this.dailySettings.add(ele);
        }
        return this;
    }

    public RecurrenceSettings withDailySettings(Collection<HandOffTime> dailySettings) {
        this.setDailySettings(dailySettings);
        return this;
    }

    public void setNumberOfOnCalls(Integer numberOfOnCalls) {
        this.numberOfOnCalls = numberOfOnCalls;
    }

    public Integer getNumberOfOnCalls() {
        return this.numberOfOnCalls;
    }

    public RecurrenceSettings withNumberOfOnCalls(Integer numberOfOnCalls) {
        this.setNumberOfOnCalls(numberOfOnCalls);
        return this;
    }

    public Map<String, List<CoverageTime>> getShiftCoverages() {
        return this.shiftCoverages;
    }

    public void setShiftCoverages(Map<String, List<CoverageTime>> shiftCoverages) {
        this.shiftCoverages = shiftCoverages;
    }

    public RecurrenceSettings withShiftCoverages(Map<String, List<CoverageTime>> shiftCoverages) {
        this.setShiftCoverages(shiftCoverages);
        return this;
    }

    public RecurrenceSettings addShiftCoveragesEntry(String key, List<CoverageTime> value) {
        if (null == this.shiftCoverages) {
            this.shiftCoverages = new HashMap<String, List<CoverageTime>>();
        }
        if (this.shiftCoverages.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.shiftCoverages.put(key, value);
        return this;
    }

    public RecurrenceSettings clearShiftCoveragesEntries() {
        this.shiftCoverages = null;
        return this;
    }

    public void setRecurrenceMultiplier(Integer recurrenceMultiplier) {
        this.recurrenceMultiplier = recurrenceMultiplier;
    }

    public Integer getRecurrenceMultiplier() {
        return this.recurrenceMultiplier;
    }

    public RecurrenceSettings withRecurrenceMultiplier(Integer recurrenceMultiplier) {
        this.setRecurrenceMultiplier(recurrenceMultiplier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMonthlySettings() != null) {
            sb.append("MonthlySettings: ").append(this.getMonthlySettings()).append(",");
        }
        if (this.getWeeklySettings() != null) {
            sb.append("WeeklySettings: ").append(this.getWeeklySettings()).append(",");
        }
        if (this.getDailySettings() != null) {
            sb.append("DailySettings: ").append(this.getDailySettings()).append(",");
        }
        if (this.getNumberOfOnCalls() != null) {
            sb.append("NumberOfOnCalls: ").append(this.getNumberOfOnCalls()).append(",");
        }
        if (this.getShiftCoverages() != null) {
            sb.append("ShiftCoverages: ").append(this.getShiftCoverages()).append(",");
        }
        if (this.getRecurrenceMultiplier() != null) {
            sb.append("RecurrenceMultiplier: ").append(this.getRecurrenceMultiplier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurrenceSettings)) {
            return false;
        }
        RecurrenceSettings other = (RecurrenceSettings)obj;
        if (other.getMonthlySettings() == null ^ this.getMonthlySettings() == null) {
            return false;
        }
        if (other.getMonthlySettings() != null && !other.getMonthlySettings().equals(this.getMonthlySettings())) {
            return false;
        }
        if (other.getWeeklySettings() == null ^ this.getWeeklySettings() == null) {
            return false;
        }
        if (other.getWeeklySettings() != null && !other.getWeeklySettings().equals(this.getWeeklySettings())) {
            return false;
        }
        if (other.getDailySettings() == null ^ this.getDailySettings() == null) {
            return false;
        }
        if (other.getDailySettings() != null && !other.getDailySettings().equals(this.getDailySettings())) {
            return false;
        }
        if (other.getNumberOfOnCalls() == null ^ this.getNumberOfOnCalls() == null) {
            return false;
        }
        if (other.getNumberOfOnCalls() != null && !other.getNumberOfOnCalls().equals(this.getNumberOfOnCalls())) {
            return false;
        }
        if (other.getShiftCoverages() == null ^ this.getShiftCoverages() == null) {
            return false;
        }
        if (other.getShiftCoverages() != null && !other.getShiftCoverages().equals(this.getShiftCoverages())) {
            return false;
        }
        if (other.getRecurrenceMultiplier() == null ^ this.getRecurrenceMultiplier() == null) {
            return false;
        }
        return other.getRecurrenceMultiplier() == null || other.getRecurrenceMultiplier().equals(this.getRecurrenceMultiplier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMonthlySettings() == null ? 0 : this.getMonthlySettings().hashCode());
        hashCode = 31 * hashCode + (this.getWeeklySettings() == null ? 0 : this.getWeeklySettings().hashCode());
        hashCode = 31 * hashCode + (this.getDailySettings() == null ? 0 : this.getDailySettings().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfOnCalls() == null ? 0 : this.getNumberOfOnCalls().hashCode());
        hashCode = 31 * hashCode + (this.getShiftCoverages() == null ? 0 : this.getShiftCoverages().hashCode());
        hashCode = 31 * hashCode + (this.getRecurrenceMultiplier() == null ? 0 : this.getRecurrenceMultiplier().hashCode());
        return hashCode;
    }

    public RecurrenceSettings clone() {
        try {
            return (RecurrenceSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecurrenceSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

