/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ssmcontacts.AWSSSMContactsAsync;
import com.amazonaws.services.ssmcontacts.AWSSSMContactsAsyncClientBuilder;
import com.amazonaws.services.ssmcontacts.AWSSSMContactsClient;
import com.amazonaws.services.ssmcontacts.model.AcceptPageRequest;
import com.amazonaws.services.ssmcontacts.model.AcceptPageResult;
import com.amazonaws.services.ssmcontacts.model.ActivateContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.ActivateContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.CreateContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.CreateContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.CreateContactRequest;
import com.amazonaws.services.ssmcontacts.model.CreateContactResult;
import com.amazonaws.services.ssmcontacts.model.CreateRotationOverrideRequest;
import com.amazonaws.services.ssmcontacts.model.CreateRotationOverrideResult;
import com.amazonaws.services.ssmcontacts.model.CreateRotationRequest;
import com.amazonaws.services.ssmcontacts.model.CreateRotationResult;
import com.amazonaws.services.ssmcontacts.model.DeactivateContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.DeactivateContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.DeleteContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.DeleteContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.DeleteContactRequest;
import com.amazonaws.services.ssmcontacts.model.DeleteContactResult;
import com.amazonaws.services.ssmcontacts.model.DeleteRotationOverrideRequest;
import com.amazonaws.services.ssmcontacts.model.DeleteRotationOverrideResult;
import com.amazonaws.services.ssmcontacts.model.DeleteRotationRequest;
import com.amazonaws.services.ssmcontacts.model.DeleteRotationResult;
import com.amazonaws.services.ssmcontacts.model.DescribeEngagementRequest;
import com.amazonaws.services.ssmcontacts.model.DescribeEngagementResult;
import com.amazonaws.services.ssmcontacts.model.DescribePageRequest;
import com.amazonaws.services.ssmcontacts.model.DescribePageResult;
import com.amazonaws.services.ssmcontacts.model.GetContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.GetContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.GetContactPolicyRequest;
import com.amazonaws.services.ssmcontacts.model.GetContactPolicyResult;
import com.amazonaws.services.ssmcontacts.model.GetContactRequest;
import com.amazonaws.services.ssmcontacts.model.GetContactResult;
import com.amazonaws.services.ssmcontacts.model.GetRotationOverrideRequest;
import com.amazonaws.services.ssmcontacts.model.GetRotationOverrideResult;
import com.amazonaws.services.ssmcontacts.model.GetRotationRequest;
import com.amazonaws.services.ssmcontacts.model.GetRotationResult;
import com.amazonaws.services.ssmcontacts.model.ListContactChannelsRequest;
import com.amazonaws.services.ssmcontacts.model.ListContactChannelsResult;
import com.amazonaws.services.ssmcontacts.model.ListContactsRequest;
import com.amazonaws.services.ssmcontacts.model.ListContactsResult;
import com.amazonaws.services.ssmcontacts.model.ListEngagementsRequest;
import com.amazonaws.services.ssmcontacts.model.ListEngagementsResult;
import com.amazonaws.services.ssmcontacts.model.ListPageReceiptsRequest;
import com.amazonaws.services.ssmcontacts.model.ListPageReceiptsResult;
import com.amazonaws.services.ssmcontacts.model.ListPageResolutionsRequest;
import com.amazonaws.services.ssmcontacts.model.ListPageResolutionsResult;
import com.amazonaws.services.ssmcontacts.model.ListPagesByContactRequest;
import com.amazonaws.services.ssmcontacts.model.ListPagesByContactResult;
import com.amazonaws.services.ssmcontacts.model.ListPagesByEngagementRequest;
import com.amazonaws.services.ssmcontacts.model.ListPagesByEngagementResult;
import com.amazonaws.services.ssmcontacts.model.ListPreviewRotationShiftsRequest;
import com.amazonaws.services.ssmcontacts.model.ListPreviewRotationShiftsResult;
import com.amazonaws.services.ssmcontacts.model.ListRotationOverridesRequest;
import com.amazonaws.services.ssmcontacts.model.ListRotationOverridesResult;
import com.amazonaws.services.ssmcontacts.model.ListRotationShiftsRequest;
import com.amazonaws.services.ssmcontacts.model.ListRotationShiftsResult;
import com.amazonaws.services.ssmcontacts.model.ListRotationsRequest;
import com.amazonaws.services.ssmcontacts.model.ListRotationsResult;
import com.amazonaws.services.ssmcontacts.model.ListTagsForResourceRequest;
import com.amazonaws.services.ssmcontacts.model.ListTagsForResourceResult;
import com.amazonaws.services.ssmcontacts.model.PutContactPolicyRequest;
import com.amazonaws.services.ssmcontacts.model.PutContactPolicyResult;
import com.amazonaws.services.ssmcontacts.model.SendActivationCodeRequest;
import com.amazonaws.services.ssmcontacts.model.SendActivationCodeResult;
import com.amazonaws.services.ssmcontacts.model.StartEngagementRequest;
import com.amazonaws.services.ssmcontacts.model.StartEngagementResult;
import com.amazonaws.services.ssmcontacts.model.StopEngagementRequest;
import com.amazonaws.services.ssmcontacts.model.StopEngagementResult;
import com.amazonaws.services.ssmcontacts.model.TagResourceRequest;
import com.amazonaws.services.ssmcontacts.model.TagResourceResult;
import com.amazonaws.services.ssmcontacts.model.UntagResourceRequest;
import com.amazonaws.services.ssmcontacts.model.UntagResourceResult;
import com.amazonaws.services.ssmcontacts.model.UpdateContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.UpdateContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.UpdateContactRequest;
import com.amazonaws.services.ssmcontacts.model.UpdateContactResult;
import com.amazonaws.services.ssmcontacts.model.UpdateRotationRequest;
import com.amazonaws.services.ssmcontacts.model.UpdateRotationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSSMContactsAsyncClient
extends AWSSSMContactsClient
implements AWSSSMContactsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSSMContactsAsyncClientBuilder asyncBuilder() {
        return AWSSSMContactsAsyncClientBuilder.standard();
    }

    AWSSSMContactsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSSMContactsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptPageResult> acceptPageAsync(AcceptPageRequest request) {
        return this.acceptPageAsync(request, null);
    }

    @Override
    public Future<AcceptPageResult> acceptPageAsync(AcceptPageRequest request, final AsyncHandler<AcceptPageRequest, AcceptPageResult> asyncHandler) {
        final AcceptPageRequest finalRequest = (AcceptPageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcceptPageResult>(){

            @Override
            public AcceptPageResult call() throws Exception {
                AcceptPageResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeAcceptPage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ActivateContactChannelResult> activateContactChannelAsync(ActivateContactChannelRequest request) {
        return this.activateContactChannelAsync(request, null);
    }

    @Override
    public Future<ActivateContactChannelResult> activateContactChannelAsync(ActivateContactChannelRequest request, final AsyncHandler<ActivateContactChannelRequest, ActivateContactChannelResult> asyncHandler) {
        final ActivateContactChannelRequest finalRequest = (ActivateContactChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ActivateContactChannelResult>(){

            @Override
            public ActivateContactChannelResult call() throws Exception {
                ActivateContactChannelResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeActivateContactChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateContactResult> createContactAsync(CreateContactRequest request) {
        return this.createContactAsync(request, null);
    }

    @Override
    public Future<CreateContactResult> createContactAsync(CreateContactRequest request, final AsyncHandler<CreateContactRequest, CreateContactResult> asyncHandler) {
        final CreateContactRequest finalRequest = (CreateContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateContactResult>(){

            @Override
            public CreateContactResult call() throws Exception {
                CreateContactResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeCreateContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateContactChannelResult> createContactChannelAsync(CreateContactChannelRequest request) {
        return this.createContactChannelAsync(request, null);
    }

    @Override
    public Future<CreateContactChannelResult> createContactChannelAsync(CreateContactChannelRequest request, final AsyncHandler<CreateContactChannelRequest, CreateContactChannelResult> asyncHandler) {
        final CreateContactChannelRequest finalRequest = (CreateContactChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateContactChannelResult>(){

            @Override
            public CreateContactChannelResult call() throws Exception {
                CreateContactChannelResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeCreateContactChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRotationResult> createRotationAsync(CreateRotationRequest request) {
        return this.createRotationAsync(request, null);
    }

    @Override
    public Future<CreateRotationResult> createRotationAsync(CreateRotationRequest request, final AsyncHandler<CreateRotationRequest, CreateRotationResult> asyncHandler) {
        final CreateRotationRequest finalRequest = (CreateRotationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRotationResult>(){

            @Override
            public CreateRotationResult call() throws Exception {
                CreateRotationResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeCreateRotation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRotationOverrideResult> createRotationOverrideAsync(CreateRotationOverrideRequest request) {
        return this.createRotationOverrideAsync(request, null);
    }

    @Override
    public Future<CreateRotationOverrideResult> createRotationOverrideAsync(CreateRotationOverrideRequest request, final AsyncHandler<CreateRotationOverrideRequest, CreateRotationOverrideResult> asyncHandler) {
        final CreateRotationOverrideRequest finalRequest = (CreateRotationOverrideRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRotationOverrideResult>(){

            @Override
            public CreateRotationOverrideResult call() throws Exception {
                CreateRotationOverrideResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeCreateRotationOverride(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeactivateContactChannelResult> deactivateContactChannelAsync(DeactivateContactChannelRequest request) {
        return this.deactivateContactChannelAsync(request, null);
    }

    @Override
    public Future<DeactivateContactChannelResult> deactivateContactChannelAsync(DeactivateContactChannelRequest request, final AsyncHandler<DeactivateContactChannelRequest, DeactivateContactChannelResult> asyncHandler) {
        final DeactivateContactChannelRequest finalRequest = (DeactivateContactChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeactivateContactChannelResult>(){

            @Override
            public DeactivateContactChannelResult call() throws Exception {
                DeactivateContactChannelResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeDeactivateContactChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteContactResult> deleteContactAsync(DeleteContactRequest request) {
        return this.deleteContactAsync(request, null);
    }

    @Override
    public Future<DeleteContactResult> deleteContactAsync(DeleteContactRequest request, final AsyncHandler<DeleteContactRequest, DeleteContactResult> asyncHandler) {
        final DeleteContactRequest finalRequest = (DeleteContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteContactResult>(){

            @Override
            public DeleteContactResult call() throws Exception {
                DeleteContactResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeDeleteContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteContactChannelResult> deleteContactChannelAsync(DeleteContactChannelRequest request) {
        return this.deleteContactChannelAsync(request, null);
    }

    @Override
    public Future<DeleteContactChannelResult> deleteContactChannelAsync(DeleteContactChannelRequest request, final AsyncHandler<DeleteContactChannelRequest, DeleteContactChannelResult> asyncHandler) {
        final DeleteContactChannelRequest finalRequest = (DeleteContactChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteContactChannelResult>(){

            @Override
            public DeleteContactChannelResult call() throws Exception {
                DeleteContactChannelResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeDeleteContactChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRotationResult> deleteRotationAsync(DeleteRotationRequest request) {
        return this.deleteRotationAsync(request, null);
    }

    @Override
    public Future<DeleteRotationResult> deleteRotationAsync(DeleteRotationRequest request, final AsyncHandler<DeleteRotationRequest, DeleteRotationResult> asyncHandler) {
        final DeleteRotationRequest finalRequest = (DeleteRotationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRotationResult>(){

            @Override
            public DeleteRotationResult call() throws Exception {
                DeleteRotationResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeDeleteRotation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRotationOverrideResult> deleteRotationOverrideAsync(DeleteRotationOverrideRequest request) {
        return this.deleteRotationOverrideAsync(request, null);
    }

    @Override
    public Future<DeleteRotationOverrideResult> deleteRotationOverrideAsync(DeleteRotationOverrideRequest request, final AsyncHandler<DeleteRotationOverrideRequest, DeleteRotationOverrideResult> asyncHandler) {
        final DeleteRotationOverrideRequest finalRequest = (DeleteRotationOverrideRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRotationOverrideResult>(){

            @Override
            public DeleteRotationOverrideResult call() throws Exception {
                DeleteRotationOverrideResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeDeleteRotationOverride(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEngagementResult> describeEngagementAsync(DescribeEngagementRequest request) {
        return this.describeEngagementAsync(request, null);
    }

    @Override
    public Future<DescribeEngagementResult> describeEngagementAsync(DescribeEngagementRequest request, final AsyncHandler<DescribeEngagementRequest, DescribeEngagementResult> asyncHandler) {
        final DescribeEngagementRequest finalRequest = (DescribeEngagementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEngagementResult>(){

            @Override
            public DescribeEngagementResult call() throws Exception {
                DescribeEngagementResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeDescribeEngagement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePageResult> describePageAsync(DescribePageRequest request) {
        return this.describePageAsync(request, null);
    }

    @Override
    public Future<DescribePageResult> describePageAsync(DescribePageRequest request, final AsyncHandler<DescribePageRequest, DescribePageResult> asyncHandler) {
        final DescribePageRequest finalRequest = (DescribePageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePageResult>(){

            @Override
            public DescribePageResult call() throws Exception {
                DescribePageResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeDescribePage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetContactResult> getContactAsync(GetContactRequest request) {
        return this.getContactAsync(request, null);
    }

    @Override
    public Future<GetContactResult> getContactAsync(GetContactRequest request, final AsyncHandler<GetContactRequest, GetContactResult> asyncHandler) {
        final GetContactRequest finalRequest = (GetContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetContactResult>(){

            @Override
            public GetContactResult call() throws Exception {
                GetContactResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeGetContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetContactChannelResult> getContactChannelAsync(GetContactChannelRequest request) {
        return this.getContactChannelAsync(request, null);
    }

    @Override
    public Future<GetContactChannelResult> getContactChannelAsync(GetContactChannelRequest request, final AsyncHandler<GetContactChannelRequest, GetContactChannelResult> asyncHandler) {
        final GetContactChannelRequest finalRequest = (GetContactChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetContactChannelResult>(){

            @Override
            public GetContactChannelResult call() throws Exception {
                GetContactChannelResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeGetContactChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetContactPolicyResult> getContactPolicyAsync(GetContactPolicyRequest request) {
        return this.getContactPolicyAsync(request, null);
    }

    @Override
    public Future<GetContactPolicyResult> getContactPolicyAsync(GetContactPolicyRequest request, final AsyncHandler<GetContactPolicyRequest, GetContactPolicyResult> asyncHandler) {
        final GetContactPolicyRequest finalRequest = (GetContactPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetContactPolicyResult>(){

            @Override
            public GetContactPolicyResult call() throws Exception {
                GetContactPolicyResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeGetContactPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRotationResult> getRotationAsync(GetRotationRequest request) {
        return this.getRotationAsync(request, null);
    }

    @Override
    public Future<GetRotationResult> getRotationAsync(GetRotationRequest request, final AsyncHandler<GetRotationRequest, GetRotationResult> asyncHandler) {
        final GetRotationRequest finalRequest = (GetRotationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRotationResult>(){

            @Override
            public GetRotationResult call() throws Exception {
                GetRotationResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeGetRotation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRotationOverrideResult> getRotationOverrideAsync(GetRotationOverrideRequest request) {
        return this.getRotationOverrideAsync(request, null);
    }

    @Override
    public Future<GetRotationOverrideResult> getRotationOverrideAsync(GetRotationOverrideRequest request, final AsyncHandler<GetRotationOverrideRequest, GetRotationOverrideResult> asyncHandler) {
        final GetRotationOverrideRequest finalRequest = (GetRotationOverrideRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRotationOverrideResult>(){

            @Override
            public GetRotationOverrideResult call() throws Exception {
                GetRotationOverrideResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeGetRotationOverride(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListContactChannelsResult> listContactChannelsAsync(ListContactChannelsRequest request) {
        return this.listContactChannelsAsync(request, null);
    }

    @Override
    public Future<ListContactChannelsResult> listContactChannelsAsync(ListContactChannelsRequest request, final AsyncHandler<ListContactChannelsRequest, ListContactChannelsResult> asyncHandler) {
        final ListContactChannelsRequest finalRequest = (ListContactChannelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListContactChannelsResult>(){

            @Override
            public ListContactChannelsResult call() throws Exception {
                ListContactChannelsResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListContactChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListContactsResult> listContactsAsync(ListContactsRequest request) {
        return this.listContactsAsync(request, null);
    }

    @Override
    public Future<ListContactsResult> listContactsAsync(ListContactsRequest request, final AsyncHandler<ListContactsRequest, ListContactsResult> asyncHandler) {
        final ListContactsRequest finalRequest = (ListContactsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListContactsResult>(){

            @Override
            public ListContactsResult call() throws Exception {
                ListContactsResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListContacts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEngagementsResult> listEngagementsAsync(ListEngagementsRequest request) {
        return this.listEngagementsAsync(request, null);
    }

    @Override
    public Future<ListEngagementsResult> listEngagementsAsync(ListEngagementsRequest request, final AsyncHandler<ListEngagementsRequest, ListEngagementsResult> asyncHandler) {
        final ListEngagementsRequest finalRequest = (ListEngagementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEngagementsResult>(){

            @Override
            public ListEngagementsResult call() throws Exception {
                ListEngagementsResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListEngagements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPageReceiptsResult> listPageReceiptsAsync(ListPageReceiptsRequest request) {
        return this.listPageReceiptsAsync(request, null);
    }

    @Override
    public Future<ListPageReceiptsResult> listPageReceiptsAsync(ListPageReceiptsRequest request, final AsyncHandler<ListPageReceiptsRequest, ListPageReceiptsResult> asyncHandler) {
        final ListPageReceiptsRequest finalRequest = (ListPageReceiptsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPageReceiptsResult>(){

            @Override
            public ListPageReceiptsResult call() throws Exception {
                ListPageReceiptsResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListPageReceipts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPageResolutionsResult> listPageResolutionsAsync(ListPageResolutionsRequest request) {
        return this.listPageResolutionsAsync(request, null);
    }

    @Override
    public Future<ListPageResolutionsResult> listPageResolutionsAsync(ListPageResolutionsRequest request, final AsyncHandler<ListPageResolutionsRequest, ListPageResolutionsResult> asyncHandler) {
        final ListPageResolutionsRequest finalRequest = (ListPageResolutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPageResolutionsResult>(){

            @Override
            public ListPageResolutionsResult call() throws Exception {
                ListPageResolutionsResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListPageResolutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPagesByContactResult> listPagesByContactAsync(ListPagesByContactRequest request) {
        return this.listPagesByContactAsync(request, null);
    }

    @Override
    public Future<ListPagesByContactResult> listPagesByContactAsync(ListPagesByContactRequest request, final AsyncHandler<ListPagesByContactRequest, ListPagesByContactResult> asyncHandler) {
        final ListPagesByContactRequest finalRequest = (ListPagesByContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPagesByContactResult>(){

            @Override
            public ListPagesByContactResult call() throws Exception {
                ListPagesByContactResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListPagesByContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPagesByEngagementResult> listPagesByEngagementAsync(ListPagesByEngagementRequest request) {
        return this.listPagesByEngagementAsync(request, null);
    }

    @Override
    public Future<ListPagesByEngagementResult> listPagesByEngagementAsync(ListPagesByEngagementRequest request, final AsyncHandler<ListPagesByEngagementRequest, ListPagesByEngagementResult> asyncHandler) {
        final ListPagesByEngagementRequest finalRequest = (ListPagesByEngagementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPagesByEngagementResult>(){

            @Override
            public ListPagesByEngagementResult call() throws Exception {
                ListPagesByEngagementResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListPagesByEngagement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPreviewRotationShiftsResult> listPreviewRotationShiftsAsync(ListPreviewRotationShiftsRequest request) {
        return this.listPreviewRotationShiftsAsync(request, null);
    }

    @Override
    public Future<ListPreviewRotationShiftsResult> listPreviewRotationShiftsAsync(ListPreviewRotationShiftsRequest request, final AsyncHandler<ListPreviewRotationShiftsRequest, ListPreviewRotationShiftsResult> asyncHandler) {
        final ListPreviewRotationShiftsRequest finalRequest = (ListPreviewRotationShiftsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPreviewRotationShiftsResult>(){

            @Override
            public ListPreviewRotationShiftsResult call() throws Exception {
                ListPreviewRotationShiftsResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListPreviewRotationShifts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRotationOverridesResult> listRotationOverridesAsync(ListRotationOverridesRequest request) {
        return this.listRotationOverridesAsync(request, null);
    }

    @Override
    public Future<ListRotationOverridesResult> listRotationOverridesAsync(ListRotationOverridesRequest request, final AsyncHandler<ListRotationOverridesRequest, ListRotationOverridesResult> asyncHandler) {
        final ListRotationOverridesRequest finalRequest = (ListRotationOverridesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRotationOverridesResult>(){

            @Override
            public ListRotationOverridesResult call() throws Exception {
                ListRotationOverridesResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListRotationOverrides(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRotationShiftsResult> listRotationShiftsAsync(ListRotationShiftsRequest request) {
        return this.listRotationShiftsAsync(request, null);
    }

    @Override
    public Future<ListRotationShiftsResult> listRotationShiftsAsync(ListRotationShiftsRequest request, final AsyncHandler<ListRotationShiftsRequest, ListRotationShiftsResult> asyncHandler) {
        final ListRotationShiftsRequest finalRequest = (ListRotationShiftsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRotationShiftsResult>(){

            @Override
            public ListRotationShiftsResult call() throws Exception {
                ListRotationShiftsResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListRotationShifts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRotationsResult> listRotationsAsync(ListRotationsRequest request) {
        return this.listRotationsAsync(request, null);
    }

    @Override
    public Future<ListRotationsResult> listRotationsAsync(ListRotationsRequest request, final AsyncHandler<ListRotationsRequest, ListRotationsResult> asyncHandler) {
        final ListRotationsRequest finalRequest = (ListRotationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRotationsResult>(){

            @Override
            public ListRotationsResult call() throws Exception {
                ListRotationsResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListRotations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutContactPolicyResult> putContactPolicyAsync(PutContactPolicyRequest request) {
        return this.putContactPolicyAsync(request, null);
    }

    @Override
    public Future<PutContactPolicyResult> putContactPolicyAsync(PutContactPolicyRequest request, final AsyncHandler<PutContactPolicyRequest, PutContactPolicyResult> asyncHandler) {
        final PutContactPolicyRequest finalRequest = (PutContactPolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutContactPolicyResult>(){

            @Override
            public PutContactPolicyResult call() throws Exception {
                PutContactPolicyResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executePutContactPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendActivationCodeResult> sendActivationCodeAsync(SendActivationCodeRequest request) {
        return this.sendActivationCodeAsync(request, null);
    }

    @Override
    public Future<SendActivationCodeResult> sendActivationCodeAsync(SendActivationCodeRequest request, final AsyncHandler<SendActivationCodeRequest, SendActivationCodeResult> asyncHandler) {
        final SendActivationCodeRequest finalRequest = (SendActivationCodeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendActivationCodeResult>(){

            @Override
            public SendActivationCodeResult call() throws Exception {
                SendActivationCodeResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeSendActivationCode(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartEngagementResult> startEngagementAsync(StartEngagementRequest request) {
        return this.startEngagementAsync(request, null);
    }

    @Override
    public Future<StartEngagementResult> startEngagementAsync(StartEngagementRequest request, final AsyncHandler<StartEngagementRequest, StartEngagementResult> asyncHandler) {
        final StartEngagementRequest finalRequest = (StartEngagementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartEngagementResult>(){

            @Override
            public StartEngagementResult call() throws Exception {
                StartEngagementResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeStartEngagement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopEngagementResult> stopEngagementAsync(StopEngagementRequest request) {
        return this.stopEngagementAsync(request, null);
    }

    @Override
    public Future<StopEngagementResult> stopEngagementAsync(StopEngagementRequest request, final AsyncHandler<StopEngagementRequest, StopEngagementResult> asyncHandler) {
        final StopEngagementRequest finalRequest = (StopEngagementRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopEngagementResult>(){

            @Override
            public StopEngagementResult call() throws Exception {
                StopEngagementResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeStopEngagement(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateContactResult> updateContactAsync(UpdateContactRequest request) {
        return this.updateContactAsync(request, null);
    }

    @Override
    public Future<UpdateContactResult> updateContactAsync(UpdateContactRequest request, final AsyncHandler<UpdateContactRequest, UpdateContactResult> asyncHandler) {
        final UpdateContactRequest finalRequest = (UpdateContactRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateContactResult>(){

            @Override
            public UpdateContactResult call() throws Exception {
                UpdateContactResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeUpdateContact(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateContactChannelResult> updateContactChannelAsync(UpdateContactChannelRequest request) {
        return this.updateContactChannelAsync(request, null);
    }

    @Override
    public Future<UpdateContactChannelResult> updateContactChannelAsync(UpdateContactChannelRequest request, final AsyncHandler<UpdateContactChannelRequest, UpdateContactChannelResult> asyncHandler) {
        final UpdateContactChannelRequest finalRequest = (UpdateContactChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateContactChannelResult>(){

            @Override
            public UpdateContactChannelResult call() throws Exception {
                UpdateContactChannelResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeUpdateContactChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRotationResult> updateRotationAsync(UpdateRotationRequest request) {
        return this.updateRotationAsync(request, null);
    }

    @Override
    public Future<UpdateRotationResult> updateRotationAsync(UpdateRotationRequest request, final AsyncHandler<UpdateRotationRequest, UpdateRotationResult> asyncHandler) {
        final UpdateRotationRequest finalRequest = (UpdateRotationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRotationResult>(){

            @Override
            public UpdateRotationResult call() throws Exception {
                UpdateRotationResult result = null;
                try {
                    result = AWSSSMContactsAsyncClient.this.executeUpdateRotation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

