/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssmcontacts.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-contacts-2021-05-03/CreateRotationOverride"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateRotationOverrideResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created rotation override.
     * </p>
     */
    private String rotationOverrideId;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created rotation override.
     * </p>
     * 
     * @param rotationOverrideId
     *        The Amazon Resource Name (ARN) of the created rotation override.
     */

    public void setRotationOverrideId(String rotationOverrideId) {
        this.rotationOverrideId = rotationOverrideId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created rotation override.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the created rotation override.
     */

    public String getRotationOverrideId() {
        return this.rotationOverrideId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the created rotation override.
     * </p>
     * 
     * @param rotationOverrideId
     *        The Amazon Resource Name (ARN) of the created rotation override.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateRotationOverrideResult withRotationOverrideId(String rotationOverrideId) {
        setRotationOverrideId(rotationOverrideId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRotationOverrideId() != null)
            sb.append("RotationOverrideId: ").append(getRotationOverrideId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateRotationOverrideResult == false)
            return false;
        CreateRotationOverrideResult other = (CreateRotationOverrideResult) obj;
        if (other.getRotationOverrideId() == null ^ this.getRotationOverrideId() == null)
            return false;
        if (other.getRotationOverrideId() != null && other.getRotationOverrideId().equals(this.getRotationOverrideId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRotationOverrideId() == null) ? 0 : getRotationOverrideId().hashCode());
        return hashCode;
    }

    @Override
    public CreateRotationOverrideResult clone() {
        try {
            return (CreateRotationOverrideResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
