/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ssmcontacts.AWSSSMContacts;
import com.amazonaws.services.ssmcontacts.AWSSSMContactsClientBuilder;
import com.amazonaws.services.ssmcontacts.model.AWSSSMContactsException;
import com.amazonaws.services.ssmcontacts.model.AcceptPageRequest;
import com.amazonaws.services.ssmcontacts.model.AcceptPageResult;
import com.amazonaws.services.ssmcontacts.model.ActivateContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.ActivateContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.CreateContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.CreateContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.CreateContactRequest;
import com.amazonaws.services.ssmcontacts.model.CreateContactResult;
import com.amazonaws.services.ssmcontacts.model.CreateRotationOverrideRequest;
import com.amazonaws.services.ssmcontacts.model.CreateRotationOverrideResult;
import com.amazonaws.services.ssmcontacts.model.CreateRotationRequest;
import com.amazonaws.services.ssmcontacts.model.CreateRotationResult;
import com.amazonaws.services.ssmcontacts.model.DeactivateContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.DeactivateContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.DeleteContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.DeleteContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.DeleteContactRequest;
import com.amazonaws.services.ssmcontacts.model.DeleteContactResult;
import com.amazonaws.services.ssmcontacts.model.DeleteRotationOverrideRequest;
import com.amazonaws.services.ssmcontacts.model.DeleteRotationOverrideResult;
import com.amazonaws.services.ssmcontacts.model.DeleteRotationRequest;
import com.amazonaws.services.ssmcontacts.model.DeleteRotationResult;
import com.amazonaws.services.ssmcontacts.model.DescribeEngagementRequest;
import com.amazonaws.services.ssmcontacts.model.DescribeEngagementResult;
import com.amazonaws.services.ssmcontacts.model.DescribePageRequest;
import com.amazonaws.services.ssmcontacts.model.DescribePageResult;
import com.amazonaws.services.ssmcontacts.model.GetContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.GetContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.GetContactPolicyRequest;
import com.amazonaws.services.ssmcontacts.model.GetContactPolicyResult;
import com.amazonaws.services.ssmcontacts.model.GetContactRequest;
import com.amazonaws.services.ssmcontacts.model.GetContactResult;
import com.amazonaws.services.ssmcontacts.model.GetRotationOverrideRequest;
import com.amazonaws.services.ssmcontacts.model.GetRotationOverrideResult;
import com.amazonaws.services.ssmcontacts.model.GetRotationRequest;
import com.amazonaws.services.ssmcontacts.model.GetRotationResult;
import com.amazonaws.services.ssmcontacts.model.ListContactChannelsRequest;
import com.amazonaws.services.ssmcontacts.model.ListContactChannelsResult;
import com.amazonaws.services.ssmcontacts.model.ListContactsRequest;
import com.amazonaws.services.ssmcontacts.model.ListContactsResult;
import com.amazonaws.services.ssmcontacts.model.ListEngagementsRequest;
import com.amazonaws.services.ssmcontacts.model.ListEngagementsResult;
import com.amazonaws.services.ssmcontacts.model.ListPageReceiptsRequest;
import com.amazonaws.services.ssmcontacts.model.ListPageReceiptsResult;
import com.amazonaws.services.ssmcontacts.model.ListPageResolutionsRequest;
import com.amazonaws.services.ssmcontacts.model.ListPageResolutionsResult;
import com.amazonaws.services.ssmcontacts.model.ListPagesByContactRequest;
import com.amazonaws.services.ssmcontacts.model.ListPagesByContactResult;
import com.amazonaws.services.ssmcontacts.model.ListPagesByEngagementRequest;
import com.amazonaws.services.ssmcontacts.model.ListPagesByEngagementResult;
import com.amazonaws.services.ssmcontacts.model.ListPreviewRotationShiftsRequest;
import com.amazonaws.services.ssmcontacts.model.ListPreviewRotationShiftsResult;
import com.amazonaws.services.ssmcontacts.model.ListRotationOverridesRequest;
import com.amazonaws.services.ssmcontacts.model.ListRotationOverridesResult;
import com.amazonaws.services.ssmcontacts.model.ListRotationShiftsRequest;
import com.amazonaws.services.ssmcontacts.model.ListRotationShiftsResult;
import com.amazonaws.services.ssmcontacts.model.ListRotationsRequest;
import com.amazonaws.services.ssmcontacts.model.ListRotationsResult;
import com.amazonaws.services.ssmcontacts.model.ListTagsForResourceRequest;
import com.amazonaws.services.ssmcontacts.model.ListTagsForResourceResult;
import com.amazonaws.services.ssmcontacts.model.PutContactPolicyRequest;
import com.amazonaws.services.ssmcontacts.model.PutContactPolicyResult;
import com.amazonaws.services.ssmcontacts.model.SendActivationCodeRequest;
import com.amazonaws.services.ssmcontacts.model.SendActivationCodeResult;
import com.amazonaws.services.ssmcontacts.model.StartEngagementRequest;
import com.amazonaws.services.ssmcontacts.model.StartEngagementResult;
import com.amazonaws.services.ssmcontacts.model.StopEngagementRequest;
import com.amazonaws.services.ssmcontacts.model.StopEngagementResult;
import com.amazonaws.services.ssmcontacts.model.TagResourceRequest;
import com.amazonaws.services.ssmcontacts.model.TagResourceResult;
import com.amazonaws.services.ssmcontacts.model.UntagResourceRequest;
import com.amazonaws.services.ssmcontacts.model.UntagResourceResult;
import com.amazonaws.services.ssmcontacts.model.UpdateContactChannelRequest;
import com.amazonaws.services.ssmcontacts.model.UpdateContactChannelResult;
import com.amazonaws.services.ssmcontacts.model.UpdateContactRequest;
import com.amazonaws.services.ssmcontacts.model.UpdateContactResult;
import com.amazonaws.services.ssmcontacts.model.UpdateRotationRequest;
import com.amazonaws.services.ssmcontacts.model.UpdateRotationResult;
import com.amazonaws.services.ssmcontacts.model.transform.AcceptPageRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.AcceptPageResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ActivateContactChannelRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ActivateContactChannelResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.CreateContactChannelRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.CreateContactChannelResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.CreateContactRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.CreateContactResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.CreateRotationOverrideRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.CreateRotationOverrideResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.CreateRotationRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.CreateRotationResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DataEncryptionExceptionUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DeactivateContactChannelRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DeactivateContactChannelResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DeleteContactChannelRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DeleteContactChannelResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DeleteContactRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DeleteContactResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DeleteRotationOverrideRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DeleteRotationOverrideResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DeleteRotationRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DeleteRotationResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DescribeEngagementRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DescribeEngagementResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DescribePageRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.DescribePageResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.GetContactChannelRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.GetContactChannelResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.GetContactPolicyRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.GetContactPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.GetContactRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.GetContactResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.GetRotationOverrideRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.GetRotationOverrideResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.GetRotationRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.GetRotationResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListContactChannelsRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListContactChannelsResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListContactsRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListContactsResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListEngagementsRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListEngagementsResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListPageReceiptsRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListPageReceiptsResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListPageResolutionsRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListPageResolutionsResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListPagesByContactRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListPagesByContactResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListPagesByEngagementRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListPagesByEngagementResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListPreviewRotationShiftsRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListPreviewRotationShiftsResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListRotationOverridesRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListRotationOverridesResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListRotationShiftsRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListRotationShiftsResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListRotationsRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListRotationsResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.PutContactPolicyRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.PutContactPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.SendActivationCodeRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.SendActivationCodeResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.StartEngagementRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.StartEngagementResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.StopEngagementRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.StopEngagementResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.UpdateContactChannelRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.UpdateContactChannelResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.UpdateContactRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.UpdateContactResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.UpdateRotationRequestProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.UpdateRotationResultJsonUnmarshaller;
import com.amazonaws.services.ssmcontacts.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSSSMContactsClient
extends AmazonWebServiceClient
implements AWSSSMContacts {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSSMContacts.class);
    private static final String DEFAULT_SIGNING_NAME = "ssm-contacts";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DataEncryptionException").withExceptionUnmarshaller((JsonErrorUnmarshaller)DataEncryptionExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSSSMContactsException.class));

    public static AWSSSMContactsClientBuilder builder() {
        return AWSSSMContactsClientBuilder.standard();
    }

    AWSSSMContactsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSSMContactsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("ssm-contacts.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ssmcontacts/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ssmcontacts/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AcceptPageResult acceptPage(AcceptPageRequest request) {
        request = (AcceptPageRequest)this.beforeClientExecution(request);
        return this.executeAcceptPage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AcceptPageResult executeAcceptPage(AcceptPageRequest acceptPageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(acceptPageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AcceptPageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AcceptPageRequestProtocolMarshaller(protocolFactory).marshall((AcceptPageRequest)super.beforeMarshalling((AmazonWebServiceRequest)acceptPageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AcceptPage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcceptPageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AcceptPageResult acceptPageResult = (AcceptPageResult)response.getAwsResponse();
            return acceptPageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ActivateContactChannelResult activateContactChannel(ActivateContactChannelRequest request) {
        request = (ActivateContactChannelRequest)this.beforeClientExecution(request);
        return this.executeActivateContactChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ActivateContactChannelResult executeActivateContactChannel(ActivateContactChannelRequest activateContactChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(activateContactChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ActivateContactChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ActivateContactChannelRequestProtocolMarshaller(protocolFactory).marshall((ActivateContactChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)activateContactChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ActivateContactChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivateContactChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ActivateContactChannelResult activateContactChannelResult = (ActivateContactChannelResult)response.getAwsResponse();
            return activateContactChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateContactResult createContact(CreateContactRequest request) {
        request = (CreateContactRequest)this.beforeClientExecution(request);
        return this.executeCreateContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateContactResult executeCreateContact(CreateContactRequest createContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateContactRequestProtocolMarshaller(protocolFactory).marshall((CreateContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)createContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateContact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateContactResult createContactResult = (CreateContactResult)response.getAwsResponse();
            return createContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateContactChannelResult createContactChannel(CreateContactChannelRequest request) {
        request = (CreateContactChannelRequest)this.beforeClientExecution(request);
        return this.executeCreateContactChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateContactChannelResult executeCreateContactChannel(CreateContactChannelRequest createContactChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createContactChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateContactChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateContactChannelRequestProtocolMarshaller(protocolFactory).marshall((CreateContactChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createContactChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateContactChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateContactChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateContactChannelResult createContactChannelResult = (CreateContactChannelResult)response.getAwsResponse();
            return createContactChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRotationResult createRotation(CreateRotationRequest request) {
        request = (CreateRotationRequest)this.beforeClientExecution(request);
        return this.executeCreateRotation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRotationResult executeCreateRotation(CreateRotationRequest createRotationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRotationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRotationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRotationRequestProtocolMarshaller(protocolFactory).marshall((CreateRotationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRotationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateRotation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRotationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRotationResult createRotationResult = (CreateRotationResult)response.getAwsResponse();
            return createRotationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRotationOverrideResult createRotationOverride(CreateRotationOverrideRequest request) {
        request = (CreateRotationOverrideRequest)this.beforeClientExecution(request);
        return this.executeCreateRotationOverride(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRotationOverrideResult executeCreateRotationOverride(CreateRotationOverrideRequest createRotationOverrideRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRotationOverrideRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRotationOverrideRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRotationOverrideRequestProtocolMarshaller(protocolFactory).marshall((CreateRotationOverrideRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRotationOverrideRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateRotationOverride");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRotationOverrideResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRotationOverrideResult createRotationOverrideResult = (CreateRotationOverrideResult)response.getAwsResponse();
            return createRotationOverrideResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeactivateContactChannelResult deactivateContactChannel(DeactivateContactChannelRequest request) {
        request = (DeactivateContactChannelRequest)this.beforeClientExecution(request);
        return this.executeDeactivateContactChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeactivateContactChannelResult executeDeactivateContactChannel(DeactivateContactChannelRequest deactivateContactChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deactivateContactChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeactivateContactChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeactivateContactChannelRequestProtocolMarshaller(protocolFactory).marshall((DeactivateContactChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deactivateContactChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeactivateContactChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeactivateContactChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeactivateContactChannelResult deactivateContactChannelResult = (DeactivateContactChannelResult)response.getAwsResponse();
            return deactivateContactChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteContactResult deleteContact(DeleteContactRequest request) {
        request = (DeleteContactRequest)this.beforeClientExecution(request);
        return this.executeDeleteContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteContactResult executeDeleteContact(DeleteContactRequest deleteContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteContactRequestProtocolMarshaller(protocolFactory).marshall((DeleteContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteContact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteContactResult deleteContactResult = (DeleteContactResult)response.getAwsResponse();
            return deleteContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteContactChannelResult deleteContactChannel(DeleteContactChannelRequest request) {
        request = (DeleteContactChannelRequest)this.beforeClientExecution(request);
        return this.executeDeleteContactChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteContactChannelResult executeDeleteContactChannel(DeleteContactChannelRequest deleteContactChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteContactChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteContactChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteContactChannelRequestProtocolMarshaller(protocolFactory).marshall((DeleteContactChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteContactChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteContactChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteContactChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteContactChannelResult deleteContactChannelResult = (DeleteContactChannelResult)response.getAwsResponse();
            return deleteContactChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRotationResult deleteRotation(DeleteRotationRequest request) {
        request = (DeleteRotationRequest)this.beforeClientExecution(request);
        return this.executeDeleteRotation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRotationResult executeDeleteRotation(DeleteRotationRequest deleteRotationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRotationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRotationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRotationRequestProtocolMarshaller(protocolFactory).marshall((DeleteRotationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRotationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRotation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRotationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRotationResult deleteRotationResult = (DeleteRotationResult)response.getAwsResponse();
            return deleteRotationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRotationOverrideResult deleteRotationOverride(DeleteRotationOverrideRequest request) {
        request = (DeleteRotationOverrideRequest)this.beforeClientExecution(request);
        return this.executeDeleteRotationOverride(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRotationOverrideResult executeDeleteRotationOverride(DeleteRotationOverrideRequest deleteRotationOverrideRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRotationOverrideRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRotationOverrideRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRotationOverrideRequestProtocolMarshaller(protocolFactory).marshall((DeleteRotationOverrideRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRotationOverrideRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRotationOverride");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRotationOverrideResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRotationOverrideResult deleteRotationOverrideResult = (DeleteRotationOverrideResult)response.getAwsResponse();
            return deleteRotationOverrideResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEngagementResult describeEngagement(DescribeEngagementRequest request) {
        request = (DescribeEngagementRequest)this.beforeClientExecution(request);
        return this.executeDescribeEngagement(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEngagementResult executeDescribeEngagement(DescribeEngagementRequest describeEngagementRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEngagementRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEngagementRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEngagementRequestProtocolMarshaller(protocolFactory).marshall((DescribeEngagementRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEngagementRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEngagement");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEngagementResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEngagementResult describeEngagementResult = (DescribeEngagementResult)response.getAwsResponse();
            return describeEngagementResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribePageResult describePage(DescribePageRequest request) {
        request = (DescribePageRequest)this.beforeClientExecution(request);
        return this.executeDescribePage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribePageResult executeDescribePage(DescribePageRequest describePageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePageRequestProtocolMarshaller(protocolFactory).marshall((DescribePageRequest)super.beforeMarshalling((AmazonWebServiceRequest)describePageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribePage");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribePageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribePageResult describePageResult = (DescribePageResult)response.getAwsResponse();
            return describePageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetContactResult getContact(GetContactRequest request) {
        request = (GetContactRequest)this.beforeClientExecution(request);
        return this.executeGetContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetContactResult executeGetContact(GetContactRequest getContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetContactRequestProtocolMarshaller(protocolFactory).marshall((GetContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)getContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetContact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetContactResult getContactResult = (GetContactResult)response.getAwsResponse();
            return getContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetContactChannelResult getContactChannel(GetContactChannelRequest request) {
        request = (GetContactChannelRequest)this.beforeClientExecution(request);
        return this.executeGetContactChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetContactChannelResult executeGetContactChannel(GetContactChannelRequest getContactChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getContactChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetContactChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetContactChannelRequestProtocolMarshaller(protocolFactory).marshall((GetContactChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)getContactChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetContactChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetContactChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetContactChannelResult getContactChannelResult = (GetContactChannelResult)response.getAwsResponse();
            return getContactChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetContactPolicyResult getContactPolicy(GetContactPolicyRequest request) {
        request = (GetContactPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetContactPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetContactPolicyResult executeGetContactPolicy(GetContactPolicyRequest getContactPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getContactPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetContactPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetContactPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetContactPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getContactPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetContactPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetContactPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetContactPolicyResult getContactPolicyResult = (GetContactPolicyResult)response.getAwsResponse();
            return getContactPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRotationResult getRotation(GetRotationRequest request) {
        request = (GetRotationRequest)this.beforeClientExecution(request);
        return this.executeGetRotation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRotationResult executeGetRotation(GetRotationRequest getRotationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRotationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRotationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRotationRequestProtocolMarshaller(protocolFactory).marshall((GetRotationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRotationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRotation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRotationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRotationResult getRotationResult = (GetRotationResult)response.getAwsResponse();
            return getRotationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRotationOverrideResult getRotationOverride(GetRotationOverrideRequest request) {
        request = (GetRotationOverrideRequest)this.beforeClientExecution(request);
        return this.executeGetRotationOverride(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRotationOverrideResult executeGetRotationOverride(GetRotationOverrideRequest getRotationOverrideRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRotationOverrideRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRotationOverrideRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRotationOverrideRequestProtocolMarshaller(protocolFactory).marshall((GetRotationOverrideRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRotationOverrideRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRotationOverride");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRotationOverrideResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRotationOverrideResult getRotationOverrideResult = (GetRotationOverrideResult)response.getAwsResponse();
            return getRotationOverrideResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListContactChannelsResult listContactChannels(ListContactChannelsRequest request) {
        request = (ListContactChannelsRequest)this.beforeClientExecution(request);
        return this.executeListContactChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListContactChannelsResult executeListContactChannels(ListContactChannelsRequest listContactChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listContactChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListContactChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListContactChannelsRequestProtocolMarshaller(protocolFactory).marshall((ListContactChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listContactChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListContactChannels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListContactChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListContactChannelsResult listContactChannelsResult = (ListContactChannelsResult)response.getAwsResponse();
            return listContactChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListContactsResult listContacts(ListContactsRequest request) {
        request = (ListContactsRequest)this.beforeClientExecution(request);
        return this.executeListContacts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListContactsResult executeListContacts(ListContactsRequest listContactsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listContactsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListContactsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListContactsRequestProtocolMarshaller(protocolFactory).marshall((ListContactsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listContactsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListContacts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListContactsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListContactsResult listContactsResult = (ListContactsResult)response.getAwsResponse();
            return listContactsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEngagementsResult listEngagements(ListEngagementsRequest request) {
        request = (ListEngagementsRequest)this.beforeClientExecution(request);
        return this.executeListEngagements(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEngagementsResult executeListEngagements(ListEngagementsRequest listEngagementsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEngagementsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEngagementsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEngagementsRequestProtocolMarshaller(protocolFactory).marshall((ListEngagementsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEngagementsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEngagements");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEngagementsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEngagementsResult listEngagementsResult = (ListEngagementsResult)response.getAwsResponse();
            return listEngagementsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPageReceiptsResult listPageReceipts(ListPageReceiptsRequest request) {
        request = (ListPageReceiptsRequest)this.beforeClientExecution(request);
        return this.executeListPageReceipts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPageReceiptsResult executeListPageReceipts(ListPageReceiptsRequest listPageReceiptsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPageReceiptsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPageReceiptsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPageReceiptsRequestProtocolMarshaller(protocolFactory).marshall((ListPageReceiptsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPageReceiptsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPageReceipts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPageReceiptsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPageReceiptsResult listPageReceiptsResult = (ListPageReceiptsResult)response.getAwsResponse();
            return listPageReceiptsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPageResolutionsResult listPageResolutions(ListPageResolutionsRequest request) {
        request = (ListPageResolutionsRequest)this.beforeClientExecution(request);
        return this.executeListPageResolutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPageResolutionsResult executeListPageResolutions(ListPageResolutionsRequest listPageResolutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPageResolutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPageResolutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPageResolutionsRequestProtocolMarshaller(protocolFactory).marshall((ListPageResolutionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPageResolutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPageResolutions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPageResolutionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPageResolutionsResult listPageResolutionsResult = (ListPageResolutionsResult)response.getAwsResponse();
            return listPageResolutionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPagesByContactResult listPagesByContact(ListPagesByContactRequest request) {
        request = (ListPagesByContactRequest)this.beforeClientExecution(request);
        return this.executeListPagesByContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPagesByContactResult executeListPagesByContact(ListPagesByContactRequest listPagesByContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPagesByContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPagesByContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPagesByContactRequestProtocolMarshaller(protocolFactory).marshall((ListPagesByContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPagesByContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPagesByContact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPagesByContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPagesByContactResult listPagesByContactResult = (ListPagesByContactResult)response.getAwsResponse();
            return listPagesByContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPagesByEngagementResult listPagesByEngagement(ListPagesByEngagementRequest request) {
        request = (ListPagesByEngagementRequest)this.beforeClientExecution(request);
        return this.executeListPagesByEngagement(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPagesByEngagementResult executeListPagesByEngagement(ListPagesByEngagementRequest listPagesByEngagementRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPagesByEngagementRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPagesByEngagementRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPagesByEngagementRequestProtocolMarshaller(protocolFactory).marshall((ListPagesByEngagementRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPagesByEngagementRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPagesByEngagement");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPagesByEngagementResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPagesByEngagementResult listPagesByEngagementResult = (ListPagesByEngagementResult)response.getAwsResponse();
            return listPagesByEngagementResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPreviewRotationShiftsResult listPreviewRotationShifts(ListPreviewRotationShiftsRequest request) {
        request = (ListPreviewRotationShiftsRequest)this.beforeClientExecution(request);
        return this.executeListPreviewRotationShifts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPreviewRotationShiftsResult executeListPreviewRotationShifts(ListPreviewRotationShiftsRequest listPreviewRotationShiftsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPreviewRotationShiftsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPreviewRotationShiftsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPreviewRotationShiftsRequestProtocolMarshaller(protocolFactory).marshall((ListPreviewRotationShiftsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPreviewRotationShiftsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPreviewRotationShifts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPreviewRotationShiftsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPreviewRotationShiftsResult listPreviewRotationShiftsResult = (ListPreviewRotationShiftsResult)response.getAwsResponse();
            return listPreviewRotationShiftsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRotationOverridesResult listRotationOverrides(ListRotationOverridesRequest request) {
        request = (ListRotationOverridesRequest)this.beforeClientExecution(request);
        return this.executeListRotationOverrides(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRotationOverridesResult executeListRotationOverrides(ListRotationOverridesRequest listRotationOverridesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRotationOverridesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRotationOverridesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRotationOverridesRequestProtocolMarshaller(protocolFactory).marshall((ListRotationOverridesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRotationOverridesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRotationOverrides");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRotationOverridesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRotationOverridesResult listRotationOverridesResult = (ListRotationOverridesResult)response.getAwsResponse();
            return listRotationOverridesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRotationShiftsResult listRotationShifts(ListRotationShiftsRequest request) {
        request = (ListRotationShiftsRequest)this.beforeClientExecution(request);
        return this.executeListRotationShifts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRotationShiftsResult executeListRotationShifts(ListRotationShiftsRequest listRotationShiftsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRotationShiftsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRotationShiftsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRotationShiftsRequestProtocolMarshaller(protocolFactory).marshall((ListRotationShiftsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRotationShiftsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRotationShifts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRotationShiftsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRotationShiftsResult listRotationShiftsResult = (ListRotationShiftsResult)response.getAwsResponse();
            return listRotationShiftsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRotationsResult listRotations(ListRotationsRequest request) {
        request = (ListRotationsRequest)this.beforeClientExecution(request);
        return this.executeListRotations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRotationsResult executeListRotations(ListRotationsRequest listRotationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRotationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRotationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRotationsRequestProtocolMarshaller(protocolFactory).marshall((ListRotationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRotationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRotations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRotationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRotationsResult listRotationsResult = (ListRotationsResult)response.getAwsResponse();
            return listRotationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutContactPolicyResult putContactPolicy(PutContactPolicyRequest request) {
        request = (PutContactPolicyRequest)this.beforeClientExecution(request);
        return this.executePutContactPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutContactPolicyResult executePutContactPolicy(PutContactPolicyRequest putContactPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putContactPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutContactPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutContactPolicyRequestProtocolMarshaller(protocolFactory).marshall((PutContactPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putContactPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutContactPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutContactPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutContactPolicyResult putContactPolicyResult = (PutContactPolicyResult)response.getAwsResponse();
            return putContactPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SendActivationCodeResult sendActivationCode(SendActivationCodeRequest request) {
        request = (SendActivationCodeRequest)this.beforeClientExecution(request);
        return this.executeSendActivationCode(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SendActivationCodeResult executeSendActivationCode(SendActivationCodeRequest sendActivationCodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(sendActivationCodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SendActivationCodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SendActivationCodeRequestProtocolMarshaller(protocolFactory).marshall((SendActivationCodeRequest)super.beforeMarshalling((AmazonWebServiceRequest)sendActivationCodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"SendActivationCode");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendActivationCodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SendActivationCodeResult sendActivationCodeResult = (SendActivationCodeResult)response.getAwsResponse();
            return sendActivationCodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartEngagementResult startEngagement(StartEngagementRequest request) {
        request = (StartEngagementRequest)this.beforeClientExecution(request);
        return this.executeStartEngagement(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartEngagementResult executeStartEngagement(StartEngagementRequest startEngagementRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startEngagementRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartEngagementRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartEngagementRequestProtocolMarshaller(protocolFactory).marshall((StartEngagementRequest)super.beforeMarshalling((AmazonWebServiceRequest)startEngagementRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartEngagement");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartEngagementResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartEngagementResult startEngagementResult = (StartEngagementResult)response.getAwsResponse();
            return startEngagementResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopEngagementResult stopEngagement(StopEngagementRequest request) {
        request = (StopEngagementRequest)this.beforeClientExecution(request);
        return this.executeStopEngagement(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopEngagementResult executeStopEngagement(StopEngagementRequest stopEngagementRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopEngagementRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopEngagementRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopEngagementRequestProtocolMarshaller(protocolFactory).marshall((StopEngagementRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopEngagementRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopEngagement");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopEngagementResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopEngagementResult stopEngagementResult = (StopEngagementResult)response.getAwsResponse();
            return stopEngagementResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateContactResult updateContact(UpdateContactRequest request) {
        request = (UpdateContactRequest)this.beforeClientExecution(request);
        return this.executeUpdateContact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateContactResult executeUpdateContact(UpdateContactRequest updateContactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateContactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateContactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateContactRequestProtocolMarshaller(protocolFactory).marshall((UpdateContactRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateContactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateContact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateContactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateContactResult updateContactResult = (UpdateContactResult)response.getAwsResponse();
            return updateContactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateContactChannelResult updateContactChannel(UpdateContactChannelRequest request) {
        request = (UpdateContactChannelRequest)this.beforeClientExecution(request);
        return this.executeUpdateContactChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateContactChannelResult executeUpdateContactChannel(UpdateContactChannelRequest updateContactChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateContactChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateContactChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateContactChannelRequestProtocolMarshaller(protocolFactory).marshall((UpdateContactChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateContactChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateContactChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateContactChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateContactChannelResult updateContactChannelResult = (UpdateContactChannelResult)response.getAwsResponse();
            return updateContactChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRotationResult updateRotation(UpdateRotationRequest request) {
        request = (UpdateRotationRequest)this.beforeClientExecution(request);
        return this.executeUpdateRotation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRotationResult executeUpdateRotation(UpdateRotationRequest updateRotationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRotationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRotationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRotationRequestProtocolMarshaller(protocolFactory).marshall((UpdateRotationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRotationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Contacts");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateRotation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRotationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRotationResult updateRotationResult = (UpdateRotationResult)response.getAwsResponse();
            return updateRotationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

