/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssmcontacts;

import javax.annotation.Generated;

import com.amazonaws.services.ssmcontacts.model.*;

/**
 * Abstract implementation of {@code AWSSSMContactsAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSSSMContactsAsync extends AbstractAWSSSMContacts implements AWSSSMContactsAsync {

    protected AbstractAWSSSMContactsAsync() {
    }

    @Override
    public java.util.concurrent.Future<AcceptPageResult> acceptPageAsync(AcceptPageRequest request) {

        return acceptPageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AcceptPageResult> acceptPageAsync(AcceptPageRequest request,
            com.amazonaws.handlers.AsyncHandler<AcceptPageRequest, AcceptPageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ActivateContactChannelResult> activateContactChannelAsync(ActivateContactChannelRequest request) {

        return activateContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ActivateContactChannelResult> activateContactChannelAsync(ActivateContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<ActivateContactChannelRequest, ActivateContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateContactResult> createContactAsync(CreateContactRequest request) {

        return createContactAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateContactResult> createContactAsync(CreateContactRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateContactRequest, CreateContactResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateContactChannelResult> createContactChannelAsync(CreateContactChannelRequest request) {

        return createContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateContactChannelResult> createContactChannelAsync(CreateContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateContactChannelRequest, CreateContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRotationResult> createRotationAsync(CreateRotationRequest request) {

        return createRotationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRotationResult> createRotationAsync(CreateRotationRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRotationRequest, CreateRotationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRotationOverrideResult> createRotationOverrideAsync(CreateRotationOverrideRequest request) {

        return createRotationOverrideAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRotationOverrideResult> createRotationOverrideAsync(CreateRotationOverrideRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRotationOverrideRequest, CreateRotationOverrideResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeactivateContactChannelResult> deactivateContactChannelAsync(DeactivateContactChannelRequest request) {

        return deactivateContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeactivateContactChannelResult> deactivateContactChannelAsync(DeactivateContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<DeactivateContactChannelRequest, DeactivateContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteContactResult> deleteContactAsync(DeleteContactRequest request) {

        return deleteContactAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteContactResult> deleteContactAsync(DeleteContactRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteContactRequest, DeleteContactResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteContactChannelResult> deleteContactChannelAsync(DeleteContactChannelRequest request) {

        return deleteContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteContactChannelResult> deleteContactChannelAsync(DeleteContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteContactChannelRequest, DeleteContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRotationResult> deleteRotationAsync(DeleteRotationRequest request) {

        return deleteRotationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRotationResult> deleteRotationAsync(DeleteRotationRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRotationRequest, DeleteRotationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRotationOverrideResult> deleteRotationOverrideAsync(DeleteRotationOverrideRequest request) {

        return deleteRotationOverrideAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRotationOverrideResult> deleteRotationOverrideAsync(DeleteRotationOverrideRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRotationOverrideRequest, DeleteRotationOverrideResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeEngagementResult> describeEngagementAsync(DescribeEngagementRequest request) {

        return describeEngagementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeEngagementResult> describeEngagementAsync(DescribeEngagementRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeEngagementRequest, DescribeEngagementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribePageResult> describePageAsync(DescribePageRequest request) {

        return describePageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribePageResult> describePageAsync(DescribePageRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribePageRequest, DescribePageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetContactResult> getContactAsync(GetContactRequest request) {

        return getContactAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetContactResult> getContactAsync(GetContactRequest request,
            com.amazonaws.handlers.AsyncHandler<GetContactRequest, GetContactResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetContactChannelResult> getContactChannelAsync(GetContactChannelRequest request) {

        return getContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetContactChannelResult> getContactChannelAsync(GetContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<GetContactChannelRequest, GetContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetContactPolicyResult> getContactPolicyAsync(GetContactPolicyRequest request) {

        return getContactPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetContactPolicyResult> getContactPolicyAsync(GetContactPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<GetContactPolicyRequest, GetContactPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRotationResult> getRotationAsync(GetRotationRequest request) {

        return getRotationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRotationResult> getRotationAsync(GetRotationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRotationRequest, GetRotationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRotationOverrideResult> getRotationOverrideAsync(GetRotationOverrideRequest request) {

        return getRotationOverrideAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRotationOverrideResult> getRotationOverrideAsync(GetRotationOverrideRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRotationOverrideRequest, GetRotationOverrideResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListContactChannelsResult> listContactChannelsAsync(ListContactChannelsRequest request) {

        return listContactChannelsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListContactChannelsResult> listContactChannelsAsync(ListContactChannelsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListContactChannelsRequest, ListContactChannelsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListContactsResult> listContactsAsync(ListContactsRequest request) {

        return listContactsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListContactsResult> listContactsAsync(ListContactsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListContactsRequest, ListContactsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListEngagementsResult> listEngagementsAsync(ListEngagementsRequest request) {

        return listEngagementsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListEngagementsResult> listEngagementsAsync(ListEngagementsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListEngagementsRequest, ListEngagementsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPageReceiptsResult> listPageReceiptsAsync(ListPageReceiptsRequest request) {

        return listPageReceiptsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPageReceiptsResult> listPageReceiptsAsync(ListPageReceiptsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPageReceiptsRequest, ListPageReceiptsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPageResolutionsResult> listPageResolutionsAsync(ListPageResolutionsRequest request) {

        return listPageResolutionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPageResolutionsResult> listPageResolutionsAsync(ListPageResolutionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPageResolutionsRequest, ListPageResolutionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPagesByContactResult> listPagesByContactAsync(ListPagesByContactRequest request) {

        return listPagesByContactAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPagesByContactResult> listPagesByContactAsync(ListPagesByContactRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPagesByContactRequest, ListPagesByContactResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPagesByEngagementResult> listPagesByEngagementAsync(ListPagesByEngagementRequest request) {

        return listPagesByEngagementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPagesByEngagementResult> listPagesByEngagementAsync(ListPagesByEngagementRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPagesByEngagementRequest, ListPagesByEngagementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPreviewRotationShiftsResult> listPreviewRotationShiftsAsync(ListPreviewRotationShiftsRequest request) {

        return listPreviewRotationShiftsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPreviewRotationShiftsResult> listPreviewRotationShiftsAsync(ListPreviewRotationShiftsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPreviewRotationShiftsRequest, ListPreviewRotationShiftsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRotationOverridesResult> listRotationOverridesAsync(ListRotationOverridesRequest request) {

        return listRotationOverridesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRotationOverridesResult> listRotationOverridesAsync(ListRotationOverridesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRotationOverridesRequest, ListRotationOverridesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRotationShiftsResult> listRotationShiftsAsync(ListRotationShiftsRequest request) {

        return listRotationShiftsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRotationShiftsResult> listRotationShiftsAsync(ListRotationShiftsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRotationShiftsRequest, ListRotationShiftsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRotationsResult> listRotationsAsync(ListRotationsRequest request) {

        return listRotationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRotationsResult> listRotationsAsync(ListRotationsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRotationsRequest, ListRotationsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutContactPolicyResult> putContactPolicyAsync(PutContactPolicyRequest request) {

        return putContactPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutContactPolicyResult> putContactPolicyAsync(PutContactPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<PutContactPolicyRequest, PutContactPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<SendActivationCodeResult> sendActivationCodeAsync(SendActivationCodeRequest request) {

        return sendActivationCodeAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SendActivationCodeResult> sendActivationCodeAsync(SendActivationCodeRequest request,
            com.amazonaws.handlers.AsyncHandler<SendActivationCodeRequest, SendActivationCodeResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartEngagementResult> startEngagementAsync(StartEngagementRequest request) {

        return startEngagementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartEngagementResult> startEngagementAsync(StartEngagementRequest request,
            com.amazonaws.handlers.AsyncHandler<StartEngagementRequest, StartEngagementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopEngagementResult> stopEngagementAsync(StopEngagementRequest request) {

        return stopEngagementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopEngagementResult> stopEngagementAsync(StopEngagementRequest request,
            com.amazonaws.handlers.AsyncHandler<StopEngagementRequest, StopEngagementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateContactResult> updateContactAsync(UpdateContactRequest request) {

        return updateContactAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateContactResult> updateContactAsync(UpdateContactRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateContactRequest, UpdateContactResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateContactChannelResult> updateContactChannelAsync(UpdateContactChannelRequest request) {

        return updateContactChannelAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateContactChannelResult> updateContactChannelAsync(UpdateContactChannelRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateContactChannelRequest, UpdateContactChannelResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateRotationResult> updateRotationAsync(UpdateRotationRequest request) {

        return updateRotationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateRotationResult> updateRotationAsync(UpdateRotationRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateRotationRequest, UpdateRotationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
