/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmcontacts.model.Page;
import java.util.Date;

@SdkInternalApi
public class PageMarshaller {
    private static final MarshallingInfo<String> PAGEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageArn").build();
    private static final MarshallingInfo<String> ENGAGEMENTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngagementArn").build();
    private static final MarshallingInfo<String> CONTACTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContactArn").build();
    private static final MarshallingInfo<String> SENDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sender").build();
    private static final MarshallingInfo<String> INCIDENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncidentId").build();
    private static final MarshallingInfo<Date> SENTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SentTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> DELIVERYTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> READTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadTime").timestampFormat("unixTimestamp").build();
    private static final PageMarshaller instance = new PageMarshaller();

    public static PageMarshaller getInstance() {
        return instance;
    }

    public void marshall(Page page, ProtocolMarshaller protocolMarshaller) {
        if (page == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)page.getPageArn(), PAGEARN_BINDING);
            protocolMarshaller.marshall((Object)page.getEngagementArn(), ENGAGEMENTARN_BINDING);
            protocolMarshaller.marshall((Object)page.getContactArn(), CONTACTARN_BINDING);
            protocolMarshaller.marshall((Object)page.getSender(), SENDER_BINDING);
            protocolMarshaller.marshall((Object)page.getIncidentId(), INCIDENTID_BINDING);
            protocolMarshaller.marshall((Object)page.getSentTime(), SENTTIME_BINDING);
            protocolMarshaller.marshall((Object)page.getDeliveryTime(), DELIVERYTIME_BINDING);
            protocolMarshaller.marshall((Object)page.getReadTime(), READTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

