/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.ssmcontacts.model.Engagement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListEngagementsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<Engagement> engagements;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListEngagementsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<Engagement> getEngagements() {
        return this.engagements;
    }

    public void setEngagements(Collection<Engagement> engagements) {
        if (engagements == null) {
            this.engagements = null;
            return;
        }
        this.engagements = new ArrayList<Engagement>(engagements);
    }

    public ListEngagementsResult withEngagements(Engagement ... engagements) {
        if (this.engagements == null) {
            this.setEngagements(new ArrayList<Engagement>(engagements.length));
        }
        for (Engagement ele : engagements) {
            this.engagements.add(ele);
        }
        return this;
    }

    public ListEngagementsResult withEngagements(Collection<Engagement> engagements) {
        this.setEngagements(engagements);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getEngagements() != null) {
            sb.append("Engagements: ").append(this.getEngagements());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementsResult)) {
            return false;
        }
        ListEngagementsResult other = (ListEngagementsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getEngagements() == null ^ this.getEngagements() == null) {
            return false;
        }
        return other.getEngagements() == null || other.getEngagements().equals(this.getEngagements());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getEngagements() == null ? 0 : this.getEngagements().hashCode());
        return hashCode;
    }

    public ListEngagementsResult clone() {
        try {
            return (ListEngagementsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

